/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.geometry;

import boofcv.alg.depth.VisualDepthOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.gui.d3.PointCloudViewer;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.FastQueueArray_I32;
import boofcv.struct.calib.VisualDepthParameters;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point3D_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DenseMatrix64F;

public class ExampleDepthPointCloud {
    public static void main(String[] args) throws IOException {
        String nameRgb = UtilIO.pathExample("kinect/basket/basket_rgb.png");
        String nameDepth = UtilIO.pathExample("kinect/basket/basket_depth.png");
        String nameCalib = UtilIO.pathExample("kinect/basket/visualdepth.xml");
        VisualDepthParameters param = (VisualDepthParameters)UtilIO.loadXML(nameCalib);
        BufferedImage buffered = UtilImageIO.loadImage(nameRgb);
        Planar<GrayU8> rgb = ConvertBufferedImage.convertFromMulti(buffered, null, true, GrayU8.class);
        GrayU16 depth = ConvertBufferedImage.convertFrom(UtilImageIO.loadImage(nameDepth), null, GrayU16.class);
        FastQueue cloud = new FastQueue(Point3D_F64.class, true);
        FastQueueArray_I32 cloudColor = new FastQueueArray_I32(3);
        VisualDepthOps.depthTo3D(param.visualParam, rgb, depth, (FastQueue<Point3D_F64>)cloud, cloudColor);
        DenseMatrix64F K = PerspectiveOps.calibrationMatrix(param.visualParam, null);
        PointCloudViewer viewer = new PointCloudViewer(K, 15.0);
        viewer.setPreferredSize(new Dimension(rgb.width, rgb.height));
        for (int i = 0; i < cloud.size; ++i) {
            Point3D_F64 p = (Point3D_F64)cloud.get(i);
            int[] color = (int[])cloudColor.get(i);
            int c = color[0] << 16 | color[1] << 8 | color[2];
            viewer.addPoint(p.x, p.y, p.z, c);
        }
        int maxValue = ImageStatistics.max(depth);
        BufferedImage depthOut = VisualizeImageData.disparity((ImageGray)depth, null, 0, maxValue, 0);
        ShowImages.showWindow(depthOut, "Depth Image");
        ShowImages.showWindow(viewer, "Point Cloud");
        System.out.println("Total points = " + cloud.size);
    }
}

