/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.fiducial;

import boofcv.abst.fiducial.SquareImage_to_FiducialDetector;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.gui.fiducial.VisualizeFiducial;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ExampleFiducialImage {
    public static void main(String[] args) {
        String imagePath = UtilIO.pathExample("fiducial/image/examples/");
        String patternPath = UtilIO.pathExample("fiducial/image/patterns/");
        String imageName = "image01.jpg";
        IntrinsicParameters param = (IntrinsicParameters)UtilIO.loadXML(imagePath, "intrinsic.xml");
        BufferedImage input = UtilImageIO.loadImage(imagePath, imageName);
        GrayF32 original = (GrayF32)((Object)ConvertBufferedImage.convertFrom(input, true, ImageType.single(GrayF32.class)));
        SquareImage_to_FiducialDetector<GrayF32> detector = FactoryFiducial.squareImage(new ConfigFiducialImage(), ConfigThreshold.local(ThresholdType.LOCAL_SQUARE, 10), GrayF32.class);
        double width = 4.0;
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "ke.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "dog.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "yu.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "yu_inverted.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "pentarose.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "text_boofcv.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "leaf01.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "leaf02.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "hand01.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "chicken.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "h2o.png", GrayF32.class), 100.0, width);
        detector.addPatternImage(UtilImageIO.loadImage(patternPath, "yinyang.png", GrayF32.class), 100.0, width);
        detector.setIntrinsic(param);
        detector.detect(original);
        Graphics2D g2 = input.createGraphics();
        Se3_F64 targetToSensor = new Se3_F64();
        for (int i = 0; i < detector.totalFound(); ++i) {
            System.out.println("Target ID = " + detector.getId(i));
            detector.getFiducialToCamera(i, targetToSensor);
            System.out.println("Location:");
            System.out.println(targetToSensor);
            VisualizeFiducial.drawLabelCenter(targetToSensor, param, "" + detector.getId(i), g2);
            VisualizeFiducial.drawCube(targetToSensor, param, detector.getWidth(i), 3, g2);
        }
        ShowImages.showWindow(input, "Fiducials", true);
    }
}

