/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.fiducial;

import boofcv.abst.fiducial.SquareBinary_to_FiducialDetector;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.gui.fiducial.VisualizeFiducial;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ExampleFiducialBinary {
    public static void main(String[] args) {
        String directory = UtilIO.pathExample("fiducial/binary");
        IntrinsicParameters param = (IntrinsicParameters)UtilIO.loadXML(directory, "intrinsic.xml");
        BufferedImage input = UtilImageIO.loadImage(directory, "image0000.jpg");
        GrayF32 original = (GrayF32)((Object)ConvertBufferedImage.convertFrom(input, true, ImageType.single(GrayF32.class)));
        SquareBinary_to_FiducialDetector<GrayF32> detector = FactoryFiducial.squareBinary(new ConfigFiducialBinary(0.1), ConfigThreshold.local(ThresholdType.LOCAL_SQUARE, 10), GrayF32.class);
        detector.setIntrinsic(param);
        detector.detect(original);
        Graphics2D g2 = input.createGraphics();
        Se3_F64 targetToSensor = new Se3_F64();
        for (int i = 0; i < detector.totalFound(); ++i) {
            System.out.println("Target ID = " + detector.getId(i));
            detector.getFiducialToCamera(i, targetToSensor);
            System.out.println("Location:");
            System.out.println(targetToSensor);
            VisualizeFiducial.drawCube(targetToSensor, param, detector.getWidth(i), 3, g2);
            VisualizeFiducial.drawLabelCenter(targetToSensor, param, "" + detector.getId(i), g2);
        }
        ShowImages.showWindow(input, "Fiducials", true);
    }
}

