/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.abst.feature.detect.line.DetectLineHoughPolar;
import boofcv.abst.feature.detect.line.DetectLineSegmentsGridRansac;
import boofcv.factory.feature.detect.line.ConfigHoughPolar;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.feature.ImageLinePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;

public class ExampleLineDetection {
    private static final float edgeThreshold = 25.0f;
    private static final int maxLines = 10;
    private static ListDisplayPanel listPanel = new ListDisplayPanel();

    public static <T extends ImageGray, D extends ImageGray> void detectLines(BufferedImage image, Class<T> imageType, Class<D> derivType) {
        Object input = ConvertBufferedImage.convertFromSingle(image, null, imageType);
        DetectLineHoughPolar<T, D> detector = FactoryDetectLineAlgs.houghPolar(new ConfigHoughPolar(3, 30, 2.0, Math.PI / 180, 25.0f, 10), imageType, derivType);
        List<LineParametric2D_F32> found = detector.detect((T)input);
        ImageLinePanel gui = new ImageLinePanel();
        gui.setBackground(image);
        gui.setLines(found);
        gui.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        listPanel.addItem(gui, "Found Lines");
    }

    public static <T extends ImageGray, D extends ImageGray> void detectLineSegments(BufferedImage image, Class<T> imageType, Class<D> derivType) {
        Object input = ConvertBufferedImage.convertFromSingle(image, null, imageType);
        DetectLineSegmentsGridRansac<Object, D> detector = FactoryDetectLineAlgs.lineRansac(40, 30.0, 2.36, true, imageType, derivType);
        List<LineSegment2D_F32> found = detector.detect(input);
        ImageLinePanel gui = new ImageLinePanel();
        gui.setBackground(image);
        gui.setLineSegments(found);
        gui.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        listPanel.addItem(gui, "Found Line Segments");
    }

    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(UtilIO.pathExample("simple_objects.jpg"));
        ExampleLineDetection.detectLines(input, GrayU8.class, GrayS16.class);
        ExampleLineDetection.detectLineSegments(input, GrayF32.class, GrayF32.class);
        ShowImages.showWindow(listPanel, "Detected Lines", true);
    }
}

