/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.shapes.ShapeFittingOps;
import boofcv.factory.feature.detect.edge.FactoryEdgeDetectors;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ConnectRule;
import boofcv.struct.PointIndex_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_I32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;

public class ExampleFitPolygon {
    static double splitFraction = 0.05;
    static double minimumSideFraction = 0.1;
    static ListDisplayPanel gui = new ListDisplayPanel();

    public static void fitBinaryImage(GrayF32 input) {
        GrayU8 binary = new GrayU8(input.width, input.height);
        BufferedImage polygon = new BufferedImage(input.width, input.height, 1);
        double mean = ImageStatistics.mean(input);
        ThresholdImageOps.threshold(input, binary, (float)mean, true);
        GrayU8 filtered = BinaryImageOps.erode8(binary, 1, null);
        filtered = BinaryImageOps.dilate8(filtered, 1, null);
        List<Contour> contours = BinaryImageOps.contour(filtered, ConnectRule.EIGHT, null);
        Graphics2D g2 = polygon.createGraphics();
        g2.setStroke(new BasicStroke(2.0f));
        for (Contour c : contours) {
            List<PointIndex_I32> vertexes = ShapeFittingOps.fitPolygon(c.external, true, splitFraction, minimumSideFraction, 100);
            g2.setColor(Color.RED);
            VisualizeShapes.drawPolygon(vertexes, true, g2);
            g2.setColor(Color.BLUE);
            for (List<Point2D_I32> internal : c.internal) {
                vertexes = ShapeFittingOps.fitPolygon(internal, true, splitFraction, minimumSideFraction, 100);
                VisualizeShapes.drawPolygon(vertexes, true, g2);
            }
        }
        gui.addImage(polygon, "Binary Blob Contours");
    }

    public static void fitCannyEdges(GrayF32 input) {
        BufferedImage displayImage = new BufferedImage(input.width, input.height, 1);
        CannyEdge<GrayF32, GrayF32> canny = FactoryEdgeDetectors.canny(2, true, true, GrayF32.class, GrayF32.class);
        canny.process(input, 0.1f, 0.3f, null);
        List<EdgeContour> contours = canny.getContours();
        Graphics2D g2 = displayImage.createGraphics();
        g2.setStroke(new BasicStroke(2.0f));
        Random rand = new Random(234L);
        for (EdgeContour e : contours) {
            g2.setColor(new Color(rand.nextInt()));
            for (EdgeSegment s : e.segments) {
                List<PointIndex_I32> vertexes = ShapeFittingOps.fitPolygon(s.points, false, splitFraction, minimumSideFraction, 100);
                VisualizeShapes.drawPolygon(vertexes, false, g2);
            }
        }
        gui.addImage(displayImage, "Canny Trace");
    }

    public static void fitCannyBinary(GrayF32 input) {
        BufferedImage displayImage = new BufferedImage(input.width, input.height, 1);
        GrayU8 binary = new GrayU8(input.width, input.height);
        CannyEdge<GrayF32, GrayF32> canny = FactoryEdgeDetectors.canny(2, false, true, GrayF32.class, GrayF32.class);
        canny.process(input, 0.1f, 0.3f, binary);
        List<Contour> contours = BinaryImageOps.contour(binary, ConnectRule.EIGHT, null);
        Graphics2D g2 = displayImage.createGraphics();
        g2.setStroke(new BasicStroke(2.0f));
        Random rand = new Random(234L);
        for (Contour c : contours) {
            List<PointIndex_I32> vertexes = ShapeFittingOps.fitPolygon(c.external, true, splitFraction, minimumSideFraction, 100);
            g2.setColor(new Color(rand.nextInt()));
            VisualizeShapes.drawPolygon(vertexes, true, g2);
        }
        gui.addImage(displayImage, "Canny Contour");
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("shapes/shapes02.png"));
        GrayF32 input = ConvertBufferedImage.convertFromSingle(image, null, GrayF32.class);
        gui.addImage(image, "Original");
        ExampleFitPolygon.fitCannyEdges(input);
        ExampleFitPolygon.fitCannyBinary(input);
        ExampleFitPolygon.fitBinaryImage(input);
        ShowImages.showWindow(gui, "Polygon from Contour", true);
    }
}

