/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.abst.distort.FDistort;
import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.factory.flow.FactoryDenseOpticalFlow;
import boofcv.gui.PanelGridPanel;
import boofcv.gui.feature.VisualizeOpticalFlow;
import boofcv.gui.image.AnimatePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import java.awt.image.BufferedImage;

public class ExampleDenseOpticalFlow {
    public static void main(String[] args) {
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String fileName0 = UtilIO.pathExample("denseflow/Urban2_07.png");
        String fileName1 = UtilIO.pathExample("denseflow/Urban2_08.png");
        DenseOpticalFlow<GrayF32> denseFlow = FactoryDenseOpticalFlow.broxWarping(null, GrayF32.class);
        BufferedImage buff0 = media.openImage(fileName0);
        BufferedImage buff1 = media.openImage(fileName1);
        GrayF32 full = new GrayF32(buff0.getWidth(), buff0.getHeight());
        GrayF32 previous = new GrayF32(full.width / 2, full.height / 2);
        GrayF32 current = (GrayF32)previous.createSameShape();
        ImageFlow flow = new ImageFlow(previous.width, previous.height);
        ConvertBufferedImage.convertFrom(buff0, full);
        new FDistort(full, previous).scaleExt().apply();
        ConvertBufferedImage.convertFrom(buff1, full);
        new FDistort(full, current).scaleExt().apply();
        denseFlow.process(previous, current, flow);
        PanelGridPanel gui = new PanelGridPanel(1, 2);
        BufferedImage converted0 = new BufferedImage(current.width, current.height, 1);
        BufferedImage converted1 = new BufferedImage(current.width, current.height, 1);
        BufferedImage visualized = new BufferedImage(current.width, current.height, 1);
        ConvertBufferedImage.convertTo(previous, converted0, true);
        ConvertBufferedImage.convertTo(current, converted1, true);
        VisualizeOpticalFlow.colorized(flow, 10.0f, visualized);
        AnimatePanel animate = new AnimatePanel(150, converted0, converted1);
        gui.add(animate);
        gui.add(visualized);
        animate.start();
        ShowImages.showWindow(gui, "Dense Optical Flow", true);
    }
}

