/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.features;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class ExampleAssociatePoints<T extends ImageGray, TD extends TupleDesc> {
    DetectDescribePoint<T, TD> detDesc;
    AssociateDescription<TD> associate;
    public List<Point2D_F64> pointsA;
    public List<Point2D_F64> pointsB;
    Class<T> imageType;

    public ExampleAssociatePoints(DetectDescribePoint<T, TD> detDesc, AssociateDescription<TD> associate, Class<T> imageType) {
        this.detDesc = detDesc;
        this.associate = associate;
        this.imageType = imageType;
    }

    public void associate(BufferedImage imageA, BufferedImage imageB) {
        T inputA = ConvertBufferedImage.convertFromSingle(imageA, null, this.imageType);
        T inputB = ConvertBufferedImage.convertFromSingle(imageB, null, this.imageType);
        this.pointsA = new ArrayList<Point2D_F64>();
        this.pointsB = new ArrayList<Point2D_F64>();
        FastQueue<TD> descA = UtilFeature.createQueue(this.detDesc, 100);
        FastQueue<TD> descB = UtilFeature.createQueue(this.detDesc, 100);
        this.describeImage(inputA, this.pointsA, descA);
        this.describeImage(inputB, this.pointsB, descB);
        this.associate.setSource(descA);
        this.associate.setDestination(descB);
        this.associate.associate();
        AssociationPanel panel = new AssociationPanel(20);
        panel.setAssociation(this.pointsA, this.pointsB, this.associate.getMatches());
        panel.setImages(imageA, imageB);
        ShowImages.showWindow(panel, "Associated Features", true);
    }

    private void describeImage(T input, List<Point2D_F64> points, FastQueue<TD> descs) {
        this.detDesc.detect(input);
        for (int i = 0; i < this.detDesc.getNumberOfFeatures(); ++i) {
            points.add(this.detDesc.getLocation(i).copy());
            ((TupleDesc)descs.grow()).setTo(this.detDesc.getDescription(i));
        }
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        DetectDescribePoint<GrayF32, BrightFeature> detDesc = FactoryDetectDescribe.surfStable(new ConfigFastHessian(1.0f, 2, 300, 1, 9, 4, 4), null, null, imageType);
        ScoreAssociation scorer = FactoryAssociation.defaultScore(detDesc.getDescriptionType());
        AssociateDescription associate = FactoryAssociation.greedy(scorer, Double.MAX_VALUE, true);
        ExampleAssociatePoints<GrayF32, BrightFeature> app = new ExampleAssociatePoints<GrayF32, BrightFeature>(detDesc, associate, imageType);
        BufferedImage imageA = UtilImageIO.loadImage(UtilIO.pathExample("stitch/kayak_01.jpg"));
        BufferedImage imageB = UtilImageIO.loadImage(UtilIO.pathExample("stitch/kayak_03.jpg"));
        app.associate(imageA, imageB);
    }
}

