/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.calibration;

import boofcv.abst.fiducial.calib.CalibrationDetectorChessboard;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.Zhang99ParamAll;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ExampleCalibrateMonocularPoints {
    public static void calibrate(List<Point2D_F64> layout, List<CalibrationObservation> observations) {
        CalibrationPlanarGridZhang99 zhang99 = new CalibrationPlanarGridZhang99(layout, true, 2, false);
        if (!zhang99.process(observations)) {
            throw new RuntimeException("Calibration failed!");
        }
        Zhang99ParamAll found = zhang99.getOptimized();
        IntrinsicParameters param = found.convertToIntrinsic();
        param.print();
        UtilIO.saveXML(param, "intrinsic.xml");
    }

    public static List<CalibrationObservation> loadObservations(CalibrationDetector detector) {
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess");
        List<String> imageNames = BoofMiscOps.directoryList(directory, "left");
        ArrayList<CalibrationObservation> ret = new ArrayList<CalibrationObservation>();
        for (String n : imageNames) {
            CalibrationObservation set = new CalibrationObservation();
            BufferedImage img = UtilImageIO.loadImage(n);
            GrayF32 input = ConvertBufferedImage.convertFrom(img, (GrayF32)null);
            if (!detector.process(input)) {
                throw new RuntimeException("Detection failed!");
            }
            ret.add(detector.getDetectedPoints());
        }
        return ret;
    }

    public static void main(String[] args) {
        CalibrationDetectorChessboard detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(7, 5, 30.0));
        List<CalibrationObservation> calibPts = ExampleCalibrateMonocularPoints.loadObservations(detector);
        ExampleCalibrateMonocularPoints.calibrate(detector.getLayout(), calibPts);
    }
}

