/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.transform.wavelet;

import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.core.image.border.BorderType;
import boofcv.factory.transform.wavelet.FactoryWaveletTransform;
import boofcv.factory.transform.wavelet.GFactoryWavelet;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class WaveletVisualizeApp<T extends ImageGray, W extends ImageGray, C extends WlCoef>
extends SelectAlgorithmAndInputPanel {
    int numLevels = 3;
    T image;
    T imageInv;
    Class<T> imageType;
    ListDisplayPanel panel = new ListDisplayPanel();
    boolean processedImage = false;

    public WaveletVisualizeApp(Class<T> imageType) {
        super(1);
        this.imageType = imageType;
        this.addWaveletDesc("Haar", GFactoryWavelet.haar(imageType));
        this.addWaveletDesc("Daub 4", GFactoryWavelet.daubJ(imageType, 4));
        this.addWaveletDesc("Bi-orthogonal 5", GFactoryWavelet.biorthogoal(imageType, 5, BorderType.REFLECT));
        this.addWaveletDesc("Coiflet 6", GFactoryWavelet.coiflet(imageType, 6));
        this.setMainGUI(this.panel);
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        this.image = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.imageInv = (ImageGray)((ImageBase)this.image)._createNew(((ImageGray)this.image).width, ((ImageGray)this.image).height);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaveletVisualizeApp.this.setPreferredSize(new Dimension(((ImageGray)WaveletVisualizeApp.this.image).width + 50, ((ImageGray)WaveletVisualizeApp.this.image).height + 20));
                WaveletVisualizeApp.this.processedImage = true;
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    private void addWaveletDesc(String name, WaveletDescription desc) {
        if (desc != null) {
            this.addAlgorithm(0, name, desc);
        }
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.image == null) {
            return;
        }
        WaveletDescription desc = (WaveletDescription)cookie;
        WaveletTransform waveletTran = FactoryWaveletTransform.create(this.image.getClass(), desc, this.numLevels, 0.0, 255.0);
        this.panel.reset();
        ImageGray imageWavelet = waveletTran.transform(this.image, null);
        waveletTran.invert(imageWavelet, this.imageInv);
        UtilWavelet.adjustForDisplay(imageWavelet, waveletTran.getLevels(), 255.0);
        BufferedImage buffWavelet = VisualizeImageData.grayMagnitude(imageWavelet, null, 255.0);
        BufferedImage buffInv = ConvertBufferedImage.convertTo(this.imageInv, null, true);
        this.panel.addImage(buffWavelet, "Transform");
        this.panel.addImage(buffInv, "Inverse");
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        BufferedImage in = UtilImageIO.loadImage("data/standard/lena512.bmp");
        WaveletVisualizeApp app = new WaveletVisualizeApp(GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("lena", UtilIO.pathExample("standard/lena512.jpg")));
        inputs.add(new PathLabel("boat", UtilIO.pathExample("standard/boat.jpg")));
        inputs.add(new PathLabel("fingerprint", UtilIO.pathExample("standard/fingerprint.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Wavelet Transforms");
    }
}

