/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.transform.pyramid;

import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.kernel.GKernelMath;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.convolve.FactoryConvolve;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class EdgeIntensitiesApp<T extends ImageGray> {
    Class<T> imageType;
    int width = 200;
    int height = 200;
    T input;
    T derivY;
    double sigma = 1.0;
    int radius = FactoryKernelGaussian.radiusForSigma(this.sigma, 1);

    public EdgeIntensitiesApp(Class<T> imageType) {
        this.imageType = imageType;
        this.input = GeneralizedImageOps.createSingleBand(imageType, this.width, this.height);
        this.derivY = GeneralizedImageOps.createSingleBand(imageType, this.width, this.height);
    }

    public void init() {
        GImageMiscOps.fillRectangle(this.input, 100.0, this.width / 2, 0, this.width / 2, this.height);
    }

    private void printIntensity(String message, T deriv) {
        System.out.printf("%20s: ", message);
        int middle = this.width / 2;
        for (int i = middle - 10; i <= middle + 10; ++i) {
            double val = GeneralizedImageOps.get(deriv, i, this.height / 2);
            System.out.printf("%5.1f ", val);
        }
        System.out.println();
    }

    public void convolveDerivOrder() {
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T blurDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T deriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T derivBlur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        BlurStorageFilter<T> funcBlur = FactoryBlurFilter.gaussian(this.imageType, this.sigma, this.radius);
        ImageGradient<T, T> funcDeriv = FactoryDerivative.three(this.imageType, this.imageType);
        funcBlur.process(this.input, blur);
        funcDeriv.process(blur, blurDeriv, this.derivY);
        funcDeriv.process(this.input, deriv, this.derivY);
        funcBlur.process(deriv, derivBlur);
        this.printIntensity("Blur->Deriv", blurDeriv);
        this.printIntensity("Deriv->Blur", blurDeriv);
    }

    public void gaussianDerivToDirectDeriv() {
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T blurDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T gaussDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        BlurStorageFilter<T> funcBlur = FactoryBlurFilter.gaussian(this.imageType, this.sigma, this.radius);
        ImageGradient<T, T> funcDeriv = FactoryDerivative.three(this.imageType, this.imageType);
        ImageGradient<T, T> funcGaussDeriv = FactoryDerivative.gaussian(this.sigma, this.radius, this.imageType, this.imageType);
        funcBlur.process(this.input, blur);
        funcDeriv.process(blur, blurDeriv, this.derivY);
        funcGaussDeriv.process(this.input, gaussDeriv, this.derivY);
        this.printIntensity("Blur->Deriv", blurDeriv);
        this.printIntensity("Gauss Deriv", gaussDeriv);
    }

    public void derivByGaussDeriv() {
        System.out.println("DxG*I");
        T blurDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        for (int level = 1; level <= 3; ++level) {
            ImageGradient<T, T> funcGaussDeriv = FactoryDerivative.gaussian(level, -1, this.imageType, this.imageType);
            funcGaussDeriv.process(this.input, blurDeriv, this.derivY);
            this.printIntensity("Sigma " + level, blurDeriv);
        }
    }

    public void derivByBlurThenDeriv() {
        System.out.println("Dx*(G*I)");
        ImageGradient<T, T> funcDeriv = FactoryDerivative.three(this.imageType, this.imageType);
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T blurDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        for (int sigma = 1; sigma <= 3; ++sigma) {
            BlurStorageFilter<T> funcBlur = FactoryBlurFilter.gaussian(this.imageType, sigma, -1);
            funcBlur.process(this.input, blur);
            funcDeriv.process(blur, blurDeriv, this.derivY);
            this.printIntensity("Sigma " + sigma, blurDeriv);
        }
    }

    public void derivByDerivThenBlur() {
        System.out.println("G*(Dx*I)");
        ImageGradient<T, T> funcDeriv = FactoryDerivative.three(this.imageType, this.imageType);
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T deriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        for (int sigma = 1; sigma <= 3; ++sigma) {
            BlurStorageFilter<T> funcBlur = FactoryBlurFilter.gaussian(this.imageType, sigma, -1);
            funcDeriv.process(this.input, deriv, this.derivY);
            funcBlur.process(deriv, blur);
            this.printIntensity("Sigma " + sigma, blur);
        }
    }

    public void derivByDerivOfBlur() {
        System.out.println("(Dx*G)*I");
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        for (int sigma = 1; sigma <= 3; ++sigma) {
            Object g = FactoryKernelGaussian.gaussian1D(GrayF32.class, sigma, -1);
            Kernel1D d = GradientThree.getKernelX(false);
            Kernel1D god = GKernelMath.convolve1D(d, g);
            ConvolveInterface<T, T> f = FactoryConvolve.convolve(god, this.imageType, this.imageType, BorderType.EXTENDED, true);
            f.process(this.input, blur);
            this.printIntensity("Sigma " + sigma, blur);
        }
    }

    public void derivByGaussThenGausDeriv() {
        System.out.println("DxG*(G*I)");
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T blurDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        for (int sigma = 1; sigma <= 3; ++sigma) {
            ImageGradient<T, T> funcGaussDeriv = FactoryDerivative.gaussian(sigma, -1, this.imageType, this.imageType);
            BlurStorageFilter<T> funcBlur = FactoryBlurFilter.gaussian(this.imageType, sigma, -1);
            funcBlur.process(this.input, blur);
            funcGaussDeriv.process(blur, blurDeriv, this.derivY);
            this.printIntensity("Sigma " + sigma, blurDeriv);
        }
    }

    public void derivByGaussGausThenDeriv() {
        System.out.println("Dx*(G*(G*I))");
        ImageGradient<T, T> funcDeriv = FactoryDerivative.three(this.imageType, this.imageType);
        T blur = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T blur2 = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        T blurDeriv = GeneralizedImageOps.createSingleBand(this.imageType, this.width, this.height);
        for (int sigma = 1; sigma <= 3; ++sigma) {
            BlurStorageFilter<T> funcBlur = FactoryBlurFilter.gaussian(this.imageType, sigma, -1);
            funcBlur.process(this.input, blur);
            funcBlur.process(blur, blur2);
            funcDeriv.process(blur2, blurDeriv, this.derivY);
            this.printIntensity("Sigma " + sigma, blurDeriv);
        }
    }

    public static void main(String[] args) {
        EdgeIntensitiesApp<GrayF32> app = new EdgeIntensitiesApp<GrayF32>(GrayF32.class);
        app.init();
        app.derivByBlurThenDeriv();
        System.out.println("-----");
        app.derivByDerivThenBlur();
        System.out.println("-----");
        app.derivByDerivOfBlur();
        System.out.println("-----");
        app.derivByGaussDeriv();
        System.out.println("-----");
        app.derivByGaussThenGausDeriv();
        System.out.println("-----");
        app.derivByGaussGausThenDeriv();
    }
}

