/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.transform.fft;

import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.alg.misc.GPixelMath;
import boofcv.alg.transform.fft.GDiscreteFourierTransformOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectInputPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class FourierVisualizeApp<T extends GrayF, W extends ImageInterleaved>
extends SelectInputPanel {
    DiscreteFourierTransform<T, W> fft;
    T image;
    W transform;
    T magnitude;
    T phase;
    ImageDataType imageType;
    ListDisplayPanel panel = new ListDisplayPanel();
    boolean processedImage = false;

    public FourierVisualizeApp(ImageDataType imageType) {
        this.imageType = imageType;
        this.image = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.transform = GeneralizedImageOps.createInterleaved(imageType, 1, 1, 2);
        this.magnitude = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.phase = (GrayF)GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.fft = GDiscreteFourierTransformOps.createTransform(imageType);
        this.setMainGUI(this.panel);
    }

    public FourierVisualizeApp(Class<T> imageType) {
        this(ImageDataType.classToType(imageType));
    }

    public void process(BufferedImage input) {
        this.setInputImage(input);
        ((ImageGray)this.image).reshape(input.getWidth(), input.getHeight());
        ((ImageInterleaved)this.transform).reshape(input.getWidth(), input.getHeight());
        ((ImageGray)this.magnitude).reshape(input.getWidth(), input.getHeight());
        ((ImageGray)this.phase).reshape(input.getWidth(), input.getHeight());
        ConvertBufferedImage.convertFrom(input, this.image, true);
        this.fft.forward(this.image, this.transform);
        GDiscreteFourierTransformOps.shiftZeroFrequency(this.transform, true);
        GDiscreteFourierTransformOps.magnitude(this.transform, this.magnitude);
        GDiscreteFourierTransformOps.phase(this.transform, this.phase);
        GPixelMath.log(this.magnitude, this.magnitude);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FourierVisualizeApp.this.setPreferredSize(new Dimension(((GrayF)FourierVisualizeApp.this.image).width + 50, ((GrayF)FourierVisualizeApp.this.image).height + 20));
                FourierVisualizeApp.this.processedImage = true;
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        if (this.image == null) {
            return;
        }
        this.panel.reset();
        BufferedImage buffMag = VisualizeImageData.grayMagnitude(this.magnitude, null, -1.0);
        BufferedImage buffPhase = VisualizeImageData.colorizeSign(this.phase, null, Math.PI);
        this.panel.addImage(this.inputImage, "Original");
        this.panel.addImage(buffMag, "Magnitude");
        this.panel.addImage(buffPhase, "Phase");
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        FourierVisualizeApp app = new FourierVisualizeApp(ImageDataType.F32);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("lena", UtilIO.pathExample("standard/lena512.jpg")));
        inputs.add(new PathLabel("boat", UtilIO.pathExample("standard/boat.jpg")));
        inputs.add(new PathLabel("fingerprint", UtilIO.pathExample("standard/fingerprint.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Discrete Fourier Transform", true);
    }
}

