/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.tracker.tld.TldParameters;
import boofcv.alg.tracker.tld.TldRegion;
import boofcv.alg.tracker.tld.TldTemplateMatching;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.image.ShowImages;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ImageRectangle;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;

public class VisualizeTldDetectionApp<T extends ImageGray, D extends ImageGray>
extends JPanel
implements MouseListener {
    BufferedImage input;
    T gray;
    TldTracker<T, D> tracker;
    int numClicks = 0;
    ImageRectangle target = new ImageRectangle();
    private FastQueue<TldRegion> candidateDetections = new FastQueue(TldRegion.class, true);

    public VisualizeTldDetectionApp(BufferedImage input, Class<T> imageType) {
        super(new BorderLayout());
        this.input = input;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, input.getWidth(), input.getHeight());
        ConvertBufferedImage.convertFrom(input, this.gray, true);
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        InterpolatePixelS<T> interpolate = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        this.tracker = new TldTracker(new TldParameters(), interpolate, gradient, imageType, derivType);
        this.tracker.setPerformLearning(false);
        this.addMouseListener(this);
        this.requestFocus();
        this.setPreferredSize(new Dimension(((ImageGray)this.gray).width, ((ImageGray)this.gray).height));
        ShowImages.showWindow(this, "Visualize Detection");
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.input, 0, 0, null);
        FastQueue<TldRegion> detected = this.tracker.getDetection().getCandidateDetections();
        this.drawDetections(g2, detected, 0);
        if (this.tracker.getDetection().isAmbiguous()) {
            this.drawDetections(g2, this.tracker.getDetection().getLocalMaximums(), Color.RED);
        } else {
            TldRegion r = this.tracker.getDetection().getBest();
            if (r != null) {
                this.drawRectangle(g2, r.rect, Color.RED, 3);
            }
        }
        this.drawRectangle(g2, this.target, Color.GREEN, 3);
        if (detected.size() != 0) {
            // empty if block
        }
    }

    private void drawDetections(Graphics2D g2, FastQueue<TldRegion> detected, int shift) {
        double max = 0.0;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < detected.size; ++i) {
            TldRegion r = (TldRegion)detected.get(i);
            if (r.confidence > max) {
                max = r.confidence;
            }
            if (!(r.confidence < min)) continue;
            min = r.confidence;
        }
        double range = max - min;
        for (TldRegion r : detected.toList()) {
            int v = (int)(255.0 * (r.confidence - min) / range);
            int rgb = v << shift;
            this.drawRectangle(g2, r.rect, new Color(rgb), 3);
        }
    }

    private void drawFerns(Graphics2D g2, int shift) {
        double max = 0.0;
        double min = Double.MAX_VALUE;
        GrowQueue_F64 value = this.tracker.getDetection().getStorageMetric();
        List<ImageRectangle> rects = this.tracker.getDetection().getStorageRect();
        for (int i = 0; i < value.size; ++i) {
            double r = -value.get(i);
            if (r > max) {
                max = r;
            }
            if (!(r < min)) continue;
            min = r;
        }
        double range = max - min;
        for (int i = 0; i < value.size; ++i) {
            double r = value.get(i);
            ImageRectangle rect = rects.get(i);
            int v = (int)(255.0 * (r - min) / range);
            int rgb = v << shift;
            this.drawRectangle(g2, rect, new Color(rgb), 3);
        }
    }

    private void drawDetections(Graphics2D g2, FastQueue<TldRegion> detected, Color c) {
        for (TldRegion r : detected.toList()) {
            this.drawRectangle(g2, r.rect, c, 3);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.numClicks == 0) {
            ++this.numClicks;
            this.target.x0 = e.getX();
            this.target.y0 = e.getY();
        } else {
            this.numClicks = 0;
            this.target.x1 = e.getX();
            this.target.y1 = e.getY();
            this.tracker.initialize(this.gray, this.target.x0, this.target.y0, this.target.x1, this.target.y1);
            this.tracker.track(this.gray);
            this.printDetectedConfidence();
            this.printDescriptions();
            this.repaint();
        }
    }

    private void printDetectedConfidence() {
        FastQueue<TldRegion> detected = this.tracker.getDetection().getLocalMaximums();
        System.out.println("Target: " + (Object)((Object)this.target));
        for (int i = 0; i < detected.size; ++i) {
            TldRegion r = (TldRegion)detected.get(i);
            System.out.println((Object)((Object)r.rect) + " confidence: " + r.confidence + "  connections " + r.connections);
        }
    }

    private void printDescriptions() {
        TldTemplateMatching<T> matching = this.tracker.getTemplateMatching();
        FastQueue<TldRegion> detected = this.tracker.getDetection().getLocalMaximums();
        NccFeature t = matching.createDescriptor();
        NccFeature f = matching.createDescriptor();
        matching.computeNccDescriptor(t, this.target.x0, this.target.y0, this.target.x1, this.target.y1);
        System.out.println("Target:");
        this.printDescription(t);
        for (int i = 0; i < detected.size; ++i) {
            TldRegion r = (TldRegion)detected.get(i);
            matching.computeNccDescriptor(f, r.rect.x0, r.rect.y0, r.rect.x1, r.rect.y1);
            System.out.println("Detected:");
            System.out.println("  " + (Object)((Object)r.rect));
            this.printDescription(f);
            System.out.println("  NCC score = " + DescriptorDistance.ncc(t, f));
            System.out.println("  Confidence = " + matching.computeConfidence(r.rect));
            System.out.println("  Distance = " + matching.distance(f, matching.getTemplatePositive()));
        }
    }

    private void printDescription(NccFeature f) {
        System.out.println("  sigma " + f.sigma);
        for (int j = 0; j < f.value.length; ++j) {
            System.out.printf("%6.1f ", f.value[j]);
        }
        System.out.println();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void drawRectangle(Graphics2D g2, ImageRectangle r, Color c, int size) {
        g2.setColor(c);
        g2.setStroke(new BasicStroke(size));
        g2.drawLine(r.x0, r.y0, r.x1, r.y0);
        g2.drawLine(r.x1, r.y0, r.x1, r.y1);
        g2.drawLine(r.x1, r.y1, r.x0, r.y1);
        g2.drawLine(r.x0, r.y1, r.x0, r.y0);
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage("/home/pja/projects/ValidationBoof/data/track_rect/TLD/01_david/00050.jpg");
        new VisualizeTldDetectionApp(image, GrayU8.class);
    }
}

