/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.tracker;

import boofcv.alg.misc.PixelMath;
import boofcv.alg.tracker.circulant.CirculantTracker;
import boofcv.core.image.ConvertImage;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageGray;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CirculantVisualizationPanel
extends JPanel
implements MouseListener {
    BufferedImage frame;
    CenterPanel centerPanel = new CenterPanel();
    Listener listener;
    int numClicks;
    ImageRectangle selected = new ImageRectangle();
    boolean hasSelected = false;
    BufferedImage template;
    BufferedImage response;
    GrayF32 tmp = new GrayF32(1, 1);

    public CirculantVisualizationPanel(Listener listener) {
        this.setLayout(new BorderLayout());
        this.listener = listener;
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        right.setPreferredSize(new Dimension(150, 400));
        right.add(new TemplatePanel());
        right.add(new ResponsePanel());
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)right, "East");
        this.centerPanel.addMouseListener(this);
        this.centerPanel.grabFocus();
    }

    public void setSelectRectangle(boolean value) {
        this.numClicks = value ? 0 : 2;
    }

    public void setFrame(final BufferedImage frame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CirculantVisualizationPanel.this.frame = frame;
                CirculantVisualizationPanel.this.centerPanel.setPreferredSize(new Dimension(frame.getWidth(), frame.getHeight()));
                CirculantVisualizationPanel.this.centerPanel.setMinimumSize(CirculantVisualizationPanel.this.centerPanel.getPreferredSize());
                CirculantVisualizationPanel.this.centerPanel.revalidate();
            }
        });
    }

    public synchronized void update(CirculantTracker tracker) {
        if (this.hasSelected) {
            RectangleLength2D_F32 r = tracker.getTargetLocation();
            this.selected.x0 = (int)r.x0;
            this.selected.y0 = (int)r.y0;
            this.selected.x1 = this.selected.x0 + (int)r.width;
            this.selected.y1 = this.selected.y0 + (int)r.height;
            GrayF64 template = tracker.getTargetTemplate();
            GrayF64 response = tracker.getResponse();
            if (this.template == null) {
                this.template = new BufferedImage(template.width, template.height, 1);
                this.response = new BufferedImage(template.width, template.height, 1);
                this.tmp.reshape(template.width, template.height);
            }
            ConvertImage.convert(template, this.tmp);
            PixelMath.plus(this.tmp, 0.5f, this.tmp);
            PixelMath.multiply(this.tmp, 255.0f, 0.0f, 255.0f, this.tmp);
            ConvertBufferedImage.convertTo(this.tmp, this.template, true);
            ConvertImage.convert(response, this.tmp);
            VisualizeImageData.colorizeSign((ImageGray)this.tmp, this.response, -1.0);
        }
        this.repaint();
    }

    public void discardSelected() {
        this.hasSelected = false;
        this.numClicks = 0;
    }

    private void drawRectangle(Graphics2D g2, ImageRectangle r, Color c, int size) {
        g2.setColor(c);
        g2.setStroke(new BasicStroke(size));
        g2.drawLine(r.x0, r.y0, r.x1, r.y0);
        g2.drawLine(r.x1, r.y0, r.x1, r.y1);
        g2.drawLine(r.x1, r.y1, r.x0, r.y1);
        g2.drawLine(r.x0, r.y1, r.x0, r.y0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.numClicks == 0) {
            this.selected.x0 = e.getX();
            this.selected.y0 = e.getY();
        } else if (this.numClicks == 1) {
            this.selected.x1 = e.getX();
            this.selected.y1 = e.getY();
            this.hasSelected = true;
            this.listener.startTracking(this.selected.x0, this.selected.y0, this.selected.x1, this.selected.y1);
        } else {
            this.listener.togglePause();
        }
        ++this.numClicks;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static interface Listener {
        public void startTracking(int var1, int var2, int var3, int var4);

        public void togglePause();
    }

    private class ResponsePanel
    extends JPanel {
        private ResponsePanel() {
        }

        @Override
        protected synchronized void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (CirculantVisualizationPanel.this.response == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)CirculantVisualizationPanel.this.response, 0, 0, null);
        }
    }

    private class TemplatePanel
    extends JPanel {
        private TemplatePanel() {
        }

        @Override
        protected synchronized void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (CirculantVisualizationPanel.this.template == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)CirculantVisualizationPanel.this.template, 0, 0, null);
        }
    }

    private class CenterPanel
    extends JPanel {
        private CenterPanel() {
        }

        @Override
        protected synchronized void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)CirculantVisualizationPanel.this.frame, 0, 0, null);
            if (CirculantVisualizationPanel.this.hasSelected) {
                CirculantVisualizationPanel.this.drawRectangle(g2, CirculantVisualizationPanel.this.selected, Color.RED, 3);
            }
        }
    }
}

