/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.shapes;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.demonstrations.shapes.DetectPolygonControlPanel;
import boofcv.demonstrations.shapes.PolygonRefineType;
import boofcv.demonstrations.shapes.ThresholdControlPanel;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.gui.DemonstrationBase;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.feature.VisualizeShapes;
import boofcv.gui.image.ImageZoomPanel;
import boofcv.gui.image.ShowImages;
import boofcv.struct.Configuration;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class DetectBlackPolygonApp<T extends ImageGray>
extends DemonstrationBase<T>
implements ThresholdControlPanel.Listener {
    Class<T> imageType;
    DetectPolygonControlPanel controls = new DetectPolygonControlPanel(this);
    VisualizePanel guiImage;
    InputToBinary<T> inputToBinary;
    BinaryPolygonDetector<T> detector;
    BufferedImage original;
    BufferedImage work;
    T inputPrev;
    GrayU8 binary = new GrayU8(1, 1);

    public DetectBlackPolygonApp(List<String> examples, Class<T> imageType) {
        super(examples, ImageType.single(imageType));
        this.imageType = imageType;
        this.guiImage = new VisualizePanel();
        this.add("West", this.controls);
        this.add("Center", this.guiImage);
        this.inputPrev = (ImageGray)((DemonstrationBase)this).imageType.createImage(1, 1);
        this.createDetector();
    }

    private synchronized void createDetector() {
        Configuration configRefine = null;
        if (this.controls.refineType == PolygonRefineType.LINE) {
            configRefine = this.controls.getConfigLine();
        } else if (this.controls.refineType == PolygonRefineType.CORNER) {
            configRefine = this.controls.getConfigCorner();
        }
        this.controls.getConfigPolygon().refine = configRefine;
        this.detector = FactoryShapeDetector.polygon(this.controls.getConfigPolygon(), this.imageType);
        this.imageThresholdUpdated();
    }

    @Override
    public synchronized void processImage(final BufferedImage buffered, T input) {
        if (buffered != null) {
            this.original = DetectBlackPolygonApp.conditionalDeclare(buffered, this.original);
            this.work = DetectBlackPolygonApp.conditionalDeclare(buffered, this.work);
            this.original.createGraphics().drawImage((Image)buffered, 0, 0, null);
            this.binary.reshape(this.work.getWidth(), this.work.getHeight());
            ((ImageGray)this.inputPrev).setTo(input);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dimension d = DetectBlackPolygonApp.this.guiImage.getPreferredSize();
                    if (d.getWidth() < (double)buffered.getWidth() || d.getHeight() < (double)buffered.getHeight()) {
                        DetectBlackPolygonApp.this.guiImage.setPreferredSize(new Dimension(buffered.getWidth(), buffered.getHeight()));
                    }
                }
            });
        } else {
            input = this.inputPrev;
        }
        this.inputToBinary.process(input, this.binary);
        this.detector.process(input, this.binary);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectBlackPolygonApp.this.viewUpdated();
            }
        });
    }

    public void viewUpdated() {
        BufferedImage active = null;
        if (this.controls.selectedView == 0) {
            active = this.original;
        } else if (this.controls.selectedView == 1) {
            VisualizeBinaryData.renderBinary(this.binary, false, this.work);
            active = this.work;
            this.work.setRGB(0, 0, this.work.getRGB(0, 0));
        } else {
            Graphics2D g2 = this.work.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, this.work.getWidth(), this.work.getHeight());
            active = this.work;
        }
        this.guiImage.setScale(this.controls.zoom);
        this.guiImage.setBufferedImage(active);
        this.guiImage.repaint();
    }

    public void configUpdate() {
        this.createDetector();
    }

    @Override
    public synchronized void imageThresholdUpdated() {
        ConfigThreshold config = this.controls.getThreshold().createConfig();
        this.inputToBinary = FactoryThresholdBinary.threshold(config, this.imageType);
        this.processImageThread(null, null);
    }

    public static void main(String[] args) {
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("shapes/polygons01.jpg");
        examples.add("shapes/shapes01.png");
        examples.add("shapes/shapes02.png");
        examples.add("shapes/concave01.jpg");
        examples.add("shapes/line_text_test_image.png");
        examples.add("shapes/polygons_border_01.jpg");
        examples.add("fiducial/binary/image0000.jpg");
        examples.add("calibration/stereo/Bumblebee2_Square/left10.jpg");
        examples.add("fiducial/square_grid/movie.mp4");
        DetectBlackPolygonApp<GrayF32> app = new DetectBlackPolygonApp<GrayF32>(examples, GrayF32.class);
        app.openFile(new File((String)examples.get(0)));
        app.waitUntilDoneProcessing();
        ShowImages.showWindow(app, "Detect Black Polygons", true);
    }

    class VisualizePanel
    extends ImageZoomPanel {
        VisualizePanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
            DetectBlackPolygonApp detectBlackPolygonApp = DetectBlackPolygonApp.this;
            synchronized (detectBlackPolygonApp) {
                List polygons;
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (DetectBlackPolygonApp.this.controls.bShowContour) {
                    List<Contour> contours = DetectBlackPolygonApp.this.detector.getAllContours();
                    g2.setStroke(new BasicStroke(1.0f));
                    g2.setColor(Color.RED);
                    VisualizeBinaryData.renderExternal(contours, false, true, this.scale, g2);
                }
                if (DetectBlackPolygonApp.this.controls.bShowLines) {
                    polygons = DetectBlackPolygonApp.this.detector.getFoundPolygons().toList();
                    g2.setColor(Color.RED);
                    g2.setStroke(new BasicStroke(3.0f));
                    for (Polygon2D_F64 p : polygons) {
                        int red = 255 * ((p.size() - 3) % 4) / 3;
                        int green = 255 * (p.size() % 5) / 4;
                        int blue = 255 * ((p.size() + 2) % 6) / 5;
                        g2.setColor(new Color(red, green, blue));
                        VisualizeShapes.drawPolygon(p, true, this.scale, g2);
                    }
                }
                if (DetectBlackPolygonApp.this.controls.bShowCorners) {
                    polygons = DetectBlackPolygonApp.this.detector.getFoundPolygons().toList();
                    g2.setColor(Color.BLUE);
                    g2.setStroke(new BasicStroke(1.0f));
                    for (Polygon2D_F64 p : polygons) {
                        for (int i = 0; i < p.size(); ++i) {
                            Point2D_F64 c = p.get(i);
                            VisualizeFeatures.drawCircle(g2, this.scale * c.x, this.scale * c.y, 5.0);
                        }
                    }
                }
            }
        }
    }
}

