/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d2;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.demonstrations.sfm.d2.Mosaic2DPanel;
import boofcv.demonstrations.sfm.d2.VideoStitchBaseApp;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;

public class VideoMosaicSequentialPointApp<I extends ImageGray, D extends ImageGray, IT extends InvertibleTransform>
extends VideoStitchBaseApp<I, IT> {
    private static int maxFeatures = 250;

    public VideoMosaicSequentialPointApp(Class<I> imageType, Class<D> derivType) {
        super(2, imageType, true, new Mosaic2DPanel());
        PkltConfig config = new PkltConfig();
        config.templateRadius = 3;
        config.pyramidScaling = new int[]{1, 2, 4, 8};
        ConfigFastHessian configFH = new ConfigFastHessian();
        configFH.initialSampleSize = 2;
        configFH.maxFeaturesPerScale = 200;
        this.addAlgorithm(0, "KLT", FactoryPointTracker.klt(config, new ConfigGeneralDetector(maxFeatures, 3, 1.0f), imageType, derivType));
        this.addAlgorithm(0, "ST-BRIEF", FactoryPointTracker.dda_ST_BRIEF(150, new ConfigGeneralDetector(400, 1, 10.0f), imageType, null));
        this.addAlgorithm(0, "ST-NCC", FactoryPointTracker.dda_ST_NCC(new ConfigGeneralDetector(500, 3, 9.0f), 10, imageType, derivType));
        this.addAlgorithm(0, "FH-SURF", FactoryPointTracker.dda_FH_SURF_Fast(configFH, null, null, imageType));
        this.addAlgorithm(0, "ST-SURF-KLT", FactoryPointTracker.combined_ST_SURF_KLT(new ConfigGeneralDetector(400, 3, 1.0f), config, 75, null, null, imageType, derivType));
        this.addAlgorithm(0, "FH-SURF-KLT", FactoryPointTracker.combined_FH_SURF_KLT(config, 75, configFH, null, null, imageType));
        this.addAlgorithm(1, "Affine", new Affine2D_F64());
        this.addAlgorithm(1, "Homography", new Homography2D_F64());
        this.absoluteMinimumTracks = 40;
        this.respawnTrackFraction = 0.3;
        this.respawnCoverageFraction = 0.8;
        this.maxJumpFraction = 0.3;
        this.inlierThreshold = 4.0;
    }

    private IT createInitialTransform() {
        float scale = 0.8f;
        if (this.fitModel instanceof Affine2D_F64) {
            Affine2D_F64 H = new Affine2D_F64((double)scale, 0.0, 0.0, (double)scale, (double)(this.stitchWidth / 4), (double)(this.stitchHeight / 4));
            return (IT)H.invert(null);
        }
        if (this.fitModel instanceof Homography2D_F64) {
            Homography2D_F64 H = new Homography2D_F64((double)scale, 0.0, (double)(this.stitchWidth / 4), 0.0, (double)scale, (double)(this.stitchHeight / 4), 0.0, 0.0, 1.0);
            return (IT)H.invert(null);
        }
        throw new RuntimeException("Need to support this model type: " + this.fitModel.getClass().getSimpleName());
    }

    @Override
    protected void init(int inputWidth, int inputHeight) {
        this.setStitchImageSize(1000, 600);
        ((Mosaic2DPanel)this.gui).setMosaicSize(this.stitchWidth, this.stitchHeight);
        this.alg.configure(this.stitchWidth, this.stitchHeight, this.createInitialTransform());
    }

    @Override
    protected boolean checkLocation(StitchingFromMotion2D.Corners corners) {
        if (this.closeToBorder(corners.p0)) {
            return true;
        }
        if (this.closeToBorder(corners.p1)) {
            return true;
        }
        if (this.closeToBorder(corners.p2)) {
            return true;
        }
        return this.closeToBorder(corners.p3);
    }

    private boolean closeToBorder(Point2D_F64 pt) {
        if (pt.x < (double)this.borderTolerance || pt.y < (double)this.borderTolerance) {
            return true;
        }
        return pt.x >= (double)(this.stitchWidth - this.borderTolerance) || pt.y >= (double)(this.stitchHeight - this.borderTolerance);
    }

    public static void main(String[] args) {
        Class<GrayF32> type;
        Class<GrayF32> derivType = type = GrayF32.class;
        VideoMosaicSequentialPointApp app = new VideoMosaicSequentialPointApp(type, derivType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Plane 1", UtilIO.pathExample("mosaic/airplane01.mjpeg")));
        inputs.add(new PathLabel("Plane 2", UtilIO.pathExample("mosaic/airplane02.mjpeg")));
        inputs.add(new PathLabel("Shake", UtilIO.pathExample("shake.mjpeg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Video Image Mosaic", true);
    }

    @Override
    protected void handleRunningStatus(int status) {
    }
}

