/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d2;

import boofcv.demonstrations.sfm.d2.Motion2DPanel;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import java.awt.Dimension;
import java.awt.Graphics2D;
import org.ddogleg.struct.FastQueue;

public class Stabilize2DPanel
extends Motion2DPanel {
    private static int outputBorder = 20;

    public void setInputSize(int width, int height) {
        this.windowWidth = 2 * width + outputBorder;
        this.windowHeight = height;
        this.setPreferredSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    protected void drawImages(double scale, Graphics2D g2) {
        int scaledInputWidth = (int)(scale * (double)this.input.getWidth());
        int scaledInputHeight = (int)(scale * (double)this.input.getHeight());
        int scaledOutputWidth = (int)(scale * (double)this.stitched.getWidth());
        int scaledOutputHeight = (int)(scale * (double)this.stitched.getHeight());
        this.distortOffX = scaledInputWidth + outputBorder;
        g2.drawImage(this.input, 0, 0, scaledInputWidth, scaledInputHeight, 0, 0, this.input.getWidth(), this.input.getHeight(), null);
        g2.drawImage(this.stitched, scaledInputWidth + outputBorder, 0, scaledInputWidth + scaledOutputWidth + outputBorder, scaledOutputHeight, 0, 0, this.stitched.getWidth(), this.stitched.getHeight(), null);
    }

    @Override
    protected void drawFeatures(float scale, Graphics2D g2) {
        int scaledInputWidth = (int)(scale * (float)this.input.getWidth());
        this.drawFeatures(scale, 0, 0, (FastQueue<Point2D_F64>)this.allTracks, (FastQueue<Point2D_F64>)this.inliers, new Homography2D_F64(), g2);
        this.drawFeatures(scale, scaledInputWidth + outputBorder, 0, (FastQueue<Point2D_F64>)this.allTracks, (FastQueue<Point2D_F64>)this.inliers, this.currToWorld, g2);
    }
}

