/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.filter;

import boofcv.abst.distort.FDistort;
import boofcv.alg.filter.kernel.GKernelMath;
import boofcv.alg.filter.kernel.SteerableKernel;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.filter.DisplayGaussianKernelApp;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmPanel;
import boofcv.gui.image.VisualizeImageData;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class DisplaySteerableBase<T extends ImageGray, K extends Kernel2D>
extends SelectAlgorithmPanel {
    protected static int imageSize = 400;
    protected static int radius = 100;
    protected Class<T> imageType;
    protected Class<K> kernelType;
    ListDisplayPanel basisPanel = new ListDisplayPanel();
    ListDisplayPanel steerPanel = new ListDisplayPanel();
    T largeImg;
    List<DisplayGaussianKernelApp.DerivType> order = new ArrayList<DisplayGaussianKernelApp.DerivType>();

    public DisplaySteerableBase(Class<T> imageType, Class<K> kernelType) {
        this.imageType = imageType;
        this.kernelType = kernelType;
        this.largeImg = GeneralizedImageOps.createSingleBand(imageType, imageSize, imageSize);
        this.addAlgorithm("Deriv X", new DisplayGaussianKernelApp.DerivType(1, 0));
        this.addAlgorithm("Deriv XX", new DisplayGaussianKernelApp.DerivType(2, 0));
        this.addAlgorithm("Deriv XXX", new DisplayGaussianKernelApp.DerivType(3, 0));
        this.addAlgorithm("Deriv XXXX", new DisplayGaussianKernelApp.DerivType(4, 0));
        this.addAlgorithm("Deriv XY", new DisplayGaussianKernelApp.DerivType(1, 1));
        this.addAlgorithm("Deriv XXY", new DisplayGaussianKernelApp.DerivType(2, 1));
        this.addAlgorithm("Deriv XYY", new DisplayGaussianKernelApp.DerivType(1, 2));
        this.addAlgorithm("Deriv XXXY", new DisplayGaussianKernelApp.DerivType(3, 1));
        this.addAlgorithm("Deriv XXYY", new DisplayGaussianKernelApp.DerivType(2, 2));
        this.addAlgorithm("Deriv XYYY", new DisplayGaussianKernelApp.DerivType(1, 3));
        JPanel content = new JPanel(new GridLayout(0, 2));
        content.add(this.basisPanel);
        content.add(this.steerPanel);
        this.setMainGUI(content);
    }

    protected abstract SteerableKernel<K> createKernel(int var1, int var2);

    @Override
    public void setActiveAlgorithm(String name, Object cookie) {
        int i;
        DisplayGaussianKernelApp.DerivType dt = (DisplayGaussianKernelApp.DerivType)cookie;
        SteerableKernel<K> steerable = this.createKernel(dt.orderX, dt.orderY);
        this.basisPanel.reset();
        for (i = 0; i < steerable.getBasisSize(); ++i) {
            Object smallImg = GKernelMath.convertToImage(steerable.getBasis(i));
            new FDistort((ImageBase)smallImg, (ImageBase)this.largeImg).scaleExt().interpNN().apply();
            double maxValue = GImageStatistics.maxAbs(this.largeImg);
            BufferedImage out = VisualizeImageData.colorizeSign(this.largeImg, null, maxValue);
            this.basisPanel.addImage(out, "Basis " + i);
        }
        this.steerPanel.reset();
        for (i = 0; i <= 20; ++i) {
            double angle = Math.PI * (double)i / 20.0;
            K kernel = steerable.compute(angle);
            Object smallImg = GKernelMath.convertToImage(kernel);
            new FDistort((ImageBase)smallImg, (ImageBase)this.largeImg).scaleExt().interpNN().apply();
            double maxValue = GImageStatistics.maxAbs(this.largeImg);
            BufferedImage out = VisualizeImageData.colorizeSign(this.largeImg, null, maxValue);
            this.steerPanel.addImage(out, String.format("%5d", (int)(180.0 * angle / Math.PI)));
        }
        this.repaint();
    }
}

