/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.feature.detect.line.DetectLineSegment;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.line.ConfigHoughFoot;
import boofcv.factory.feature.detect.line.ConfigHoughFootSubimage;
import boofcv.factory.feature.detect.line.ConfigHoughPolar;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.gui.VideoProcessAppBase;
import boofcv.gui.feature.ImageLinePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VideoDisplayLinesApp<I extends ImageGray, D extends ImageGray>
extends VideoProcessAppBase<I>
implements MouseListener {
    I blur;
    float edgeThreshold = 20.0f;
    int maxLines = 10;
    int blurRadius = 2;
    ImageLinePanel gui = new ImageLinePanel();
    boolean processedImage = false;
    Object lineDetector;

    public VideoDisplayLinesApp(Class<I> imageType, Class<D> derivType) {
        super(1, imageType);
        this.addAlgorithm(0, "Hough Foot", FactoryDetectLineAlgs.houghFoot(new ConfigHoughFoot(3, 8, 5, this.edgeThreshold, this.maxLines), imageType, derivType));
        this.addAlgorithm(0, "Hough Polar", FactoryDetectLineAlgs.houghPolar(new ConfigHoughPolar(3, 30, 2.0, Math.PI / 180, this.edgeThreshold, this.maxLines), imageType, derivType));
        this.addAlgorithm(0, "Hough Foot Sub Image", FactoryDetectLineAlgs.houghFootSub(new ConfigHoughFootSubimage(3, 8, 5, this.edgeThreshold, this.maxLines, 2, 2), imageType, derivType));
        this.addAlgorithm(0, "Grid Line", FactoryDetectLineAlgs.lineRansac(40, 30.0, 2.36, true, imageType, derivType));
        this.blur = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.gui.addMouseListener(this);
        this.gui.requestFocus();
        this.setMainGUI(this.gui);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void process(SimpleImageSequence<I> sequence) {
        this.stopWorker();
        this.sequence = sequence;
        sequence.setLoop(true);
        this.doRefreshAll();
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.sequence == null) {
            return;
        }
        this.stopWorker();
        this.lineDetector = cookie;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VideoDisplayLinesApp.this.sequence.reset();
                ImageGray image = (ImageGray)VideoDisplayLinesApp.this.sequence.next();
                ((ImageGray)VideoDisplayLinesApp.this.blur).reshape(image.width, image.height);
                VideoDisplayLinesApp.this.gui.setPreferredSize(new Dimension(image.width, image.height));
                VideoDisplayLinesApp.this.revalidate();
                VideoDisplayLinesApp.this.startWorkerThread();
            }
        });
    }

    @Override
    protected void updateAlg(I frame, BufferedImage buffImage) {
        if (this.lineDetector instanceof DetectLine) {
            GBlurImageOps.gaussian(frame, this.blur, -1.0, this.blurRadius, null);
            final DetectLine detector = (DetectLine)this.lineDetector;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VideoDisplayLinesApp.this.gui.setLines(detector.detect(VideoDisplayLinesApp.this.blur));
                    VideoDisplayLinesApp.this.gui.repaint();
                    VideoDisplayLinesApp.this.processedImage = true;
                }
            });
        } else if (this.lineDetector instanceof DetectLineSegment) {
            final DetectLineSegment detector = (DetectLineSegment)this.lineDetector;
            SwingUtilities.invokeLater(new Runnable((ImageGray)frame){
                final /* synthetic */ ImageGray val$frame;
                {
                    this.val$frame = imageGray;
                }

                @Override
                public void run() {
                    VideoDisplayLinesApp.this.gui.setLineSegments(detector.detect(this.val$frame));
                    VideoDisplayLinesApp.this.gui.repaint();
                    VideoDisplayLinesApp.this.processedImage = true;
                }
            });
        }
    }

    @Override
    protected void handleRunningStatus(int status) {
    }

    @Override
    protected void updateAlgGUI(ImageGray frame, BufferedImage imageGUI, double fps) {
        this.gui.setBackground(imageGUI);
    }

    public static void main(String[] args) {
        VideoDisplayLinesApp<GrayF32, GrayF32> app = new VideoDisplayLinesApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Apartment", UtilIO.pathExample("lines_indoors.mjpeg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Feature Tracker", true);
    }
}

