/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.interest;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import java.awt.image.BufferedImage;

public class DebugSiftDetectorApp {
    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(UtilIO.pathExample("sunflowers.jpg"));
        GrayF32 gray = ConvertBufferedImage.convertFromSingle(input, null, GrayF32.class);
        NonMaxSuppression nonmax = FactoryFeatureExtractor.nonmax(new ConfigExtract(3, 1.0f, 1, true, true, true));
        NonMaxLimiter extractor = new NonMaxLimiter(nonmax, 400);
        SiftScaleSpace imageSS = new SiftScaleSpace(-1, 5, 3, 2.75);
        SiftDetector alg = new SiftDetector(imageSS, 10.0, extractor);
        alg.process(gray);
        System.out.println("total features found: " + alg.getDetections().size());
        VisualizeFeatures.drawScalePoints(input.createGraphics(), alg.getDetections().toList(), 1.0);
        ShowImages.showWindow(input, "Found Features", true);
        System.out.println("Done");
    }
}

