/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.intensity;

import boofcv.abst.distort.FDistort;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianBlobIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class IntensityFeaturePyramidApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    ListDisplayPanel gui = new ListDisplayPanel();
    PyramidFloat<T> pyramid;
    BufferedImage input;
    T workImage;
    GrayF32 scaledIntensity;
    Class<T> imageType;
    AnyImageDerivative<T, D> anyDerivative;
    boolean processedImage = false;
    GeneralFeatureIntensity<T, D> intensity;

    public IntensityFeaturePyramidApp(Class<T> imageType, Class<D> derivType) {
        super(2);
        this.imageType = imageType;
        this.addAlgorithm(0, "Hessian Det", new WrapperHessianBlobIntensity(HessianBlobIntensity.Type.DETERMINANT, derivType));
        this.addAlgorithm(0, "Laplacian", new WrapperHessianBlobIntensity(HessianBlobIntensity.Type.TRACE, derivType));
        this.addAlgorithm(0, "Harris", new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.harris(2, 0.4f, false, derivType)));
        this.addAlgorithm(0, "Shi Tomasi", new WrapperGradientCornerIntensity(FactoryIntensityPointAlg.shiTomasi(2, false, derivType)));
        this.addAlgorithm(0, "FAST", new WrapperFastCornerIntensity(FactoryIntensityPointAlg.fast(5, 11, imageType)));
        this.addAlgorithm(0, "KitRos", new WrapperKitRosCornerIntensity(derivType));
        this.addAlgorithm(0, "Median", new WrapperMedianCornerIntensity(FactoryBlurFilter.median(imageType, 2), imageType));
        this.addAlgorithm(1, "Pyramid", 0);
        this.addAlgorithm(1, "Scale-Space", 1);
        this.setMainGUI(this.gui);
        this.anyDerivative = GImageDerivativeOps.derivativeForScaleSpace(imageType, derivType);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.input == null) {
            return;
        }
        if (indexFamily == 0) {
            this.intensity = (GeneralFeatureIntensity)cookie;
            if (this.pyramid == null) {
                return;
            }
        } else if (indexFamily == 1) {
            double[] scales = new double[25];
            for (int i = 0; i < scales.length; ++i) {
                scales[i] = Math.exp((double)i * 0.15);
            }
            this.pyramid = ((Number)cookie).intValue() == 0 ? FactoryPyramid.scaleSpacePyramid(scales, this.imageType) : FactoryPyramid.scaleSpace(scales, this.imageType);
            if (this.workImage != null) {
                this.pyramid.process(this.workImage);
            }
            if (this.intensity == null) {
                return;
            }
        }
        this.gui.reset();
        BufferedImage b = VisualizeImageData.grayMagnitude(this.workImage, null, 255.0);
        this.gui.addImage(b, "Gray Image");
        final ProgressMonitor progressMonitor = new ProgressMonitor(this, "Computing Scale Space Pyramid Response", "", 0, this.pyramid.getNumLayers());
        for (int i = 0; i < this.pyramid.getNumLayers() && !progressMonitor.isCanceled(); ++i) {
            double scale = this.pyramid.getSigma(i);
            ImageBase scaledImage = this.pyramid.getLayer(i);
            this.anyDerivative.setInput(scaledImage);
            D derivX = this.anyDerivative.getDerivative(true);
            D derivY = this.anyDerivative.getDerivative(false);
            D derivXX = this.anyDerivative.getDerivative(true, true);
            D derivYY = this.anyDerivative.getDerivative(false, false);
            D derivXY = this.anyDerivative.getDerivative(true, false);
            this.intensity.process(scaledImage, derivX, derivY, derivXX, derivYY, derivXY);
            GrayF32 featureImg = this.intensity.getIntensity();
            new FDistort(featureImg, this.scaledIntensity).interpNN().scaleExt().apply();
            b = VisualizeImageData.colorizeSign((ImageGray)this.scaledIntensity, null, (double)ImageStatistics.maxAbs(this.scaledIntensity));
            this.gui.addImage(b, String.format("Scale %6.2f", scale));
            final int progressStatus = i + 1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressMonitor.setProgress(progressStatus);
                }
            });
        }
        this.gui.requestFocusInWindow();
    }

    public void process(final BufferedImage input) {
        this.setInputImage(input);
        this.input = input;
        this.workImage = ConvertBufferedImage.convertFromSingle(input, null, this.imageType);
        this.scaledIntensity = new GrayF32(((ImageGray)this.workImage).width, ((ImageGray)this.workImage).height);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntensityFeaturePyramidApp.this.setPreferredSize(new Dimension(input.getWidth(), input.getHeight()));
                IntensityFeaturePyramidApp.this.processedImage = true;
            }
        });
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.intensity = null;
        this.pyramid = null;
        this.setActiveAlgorithm(0, null, cookies[0]);
        this.setActiveAlgorithm(1, null, cookies[1]);
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        IntensityFeaturePyramidApp<GrayF32, GrayF32> app = new IntensityFeaturePyramidApp<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("amoeba", UtilIO.pathExample("amoeba_shapes.jpg")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Feature Scale Space Pyramid Intensity", true);
    }
}

