/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.edge;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CannyControlBar
extends JPanel
implements ChangeListener {
    JSpinner controlBlur;
    JSlider controlThreshold;
    int blurRadius;
    int threshold;
    Listener listener;

    public CannyControlBar(int blurRadius, int threshold) {
        this.blurRadius = blurRadius;
        this.threshold = threshold;
        this.setLayout(new BoxLayout(this, 0));
        this.controlBlur = new JSpinner(new SpinnerNumberModel(blurRadius, 1, 20, 1));
        this.controlBlur.addChangeListener(this);
        this.controlBlur.setPreferredSize(new Dimension((int)this.controlBlur.getPreferredSize().getWidth(), (int)this.controlBlur.getPreferredSize().getHeight() + 8));
        this.controlBlur.setMaximumSize(this.controlBlur.getPreferredSize());
        this.controlThreshold = new JSlider(0, 5, 100, threshold);
        this.controlThreshold.setMajorTickSpacing(20);
        this.controlThreshold.setPaintTicks(true);
        this.controlThreshold.addChangeListener(this);
        this.add(new JLabel("Blur Radius"));
        this.add(this.controlBlur);
        this.add(new JLabel("Threshold"));
        this.add(this.controlThreshold);
        this.add(Box.createHorizontalGlue());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.controlBlur == e.getSource()) {
            this.blurRadius = ((Number)this.controlBlur.getValue()).intValue();
        } else if (this.controlThreshold == e.getSource()) {
            this.threshold = this.controlThreshold.getValue();
        }
        if (this.listener != null) {
            this.listener.changeCanny();
        }
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void changeCanny();
    }
}

