/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.describe;

import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.SelectRegionDescriptionPanel;
import boofcv.gui.feature.TupleDescPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_I32;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class VisualizeRegionDescriptionApp<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements SelectRegionDescriptionPanel.Listener {
    boolean processedImage = false;
    Class<T> imageType;
    BufferedImage image;
    DescribeRegionPoint describe;
    SelectRegionDescriptionPanel panel = new SelectRegionDescriptionPanel();
    TupleDescPanel tuplePanel = new TupleDescPanel();
    Point2D_I32 targetPt;
    double targetRadius;
    double targetOrientation;

    public VisualizeRegionDescriptionApp(Class<T> imageType, Class<D> derivType) {
        super(1);
        this.imageType = imageType;
        this.addAlgorithm(0, "SURF-S", FactoryDescribeRegionPoint.surfStable(null, imageType));
        this.addAlgorithm(0, "SURF-S Color", FactoryDescribeRegionPoint.surfColorStable(null, ImageType.pl(3, imageType)));
        this.addAlgorithm(0, "SIFT", FactoryDescribeRegionPoint.sift(null, null, imageType));
        this.addAlgorithm(0, "BRIEF", FactoryDescribeRegionPoint.brief(new ConfigBrief(true), imageType));
        this.addAlgorithm(0, "BRIEFO", FactoryDescribeRegionPoint.brief(new ConfigBrief(false), imageType));
        this.addAlgorithm(0, "Pixel 5x5", FactoryDescribeRegionPoint.pixel(5, 5, imageType));
        this.addAlgorithm(0, "NCC 5x5", FactoryDescribeRegionPoint.pixelNCC(5, 5, imageType));
        this.panel.setListener(this);
        this.tuplePanel.setPreferredSize(new Dimension(100, 50));
        this.add((Component)this.tuplePanel, "South");
        this.setMainGUI(this.panel);
    }

    public void process(final BufferedImage image) {
        this.image = image;
        this.setDescriptorInput();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeRegionDescriptionApp.this.panel.setBackground(image);
                VisualizeRegionDescriptionApp.this.panel.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
                VisualizeRegionDescriptionApp.this.processedImage = true;
            }
        });
        this.doRefreshAll();
    }

    private void setDescriptorInput() {
        if (this.describe != null) {
            if (this.describe.getImageType().getFamily() == ImageType.Family.GRAY) {
                Object input = ConvertBufferedImage.convertFromSingle(this.image, null, this.imageType);
                this.describe.setImage(input);
            } else {
                Planar<T> input = ConvertBufferedImage.convertFromMulti(this.image, null, true, this.imageType);
                this.describe.setImage(input);
            }
        }
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.describe = (DescribeRegionPoint)cookie;
        this.setDescriptorInput();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeRegionDescriptionApp.this.updateTargetDescription();
                VisualizeRegionDescriptionApp.this.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        this.process(image);
    }

    @Override
    public synchronized void descriptionChanged(Point2D_I32 pt, double radius, double orientation) {
        if (pt == null || radius < 1.0) {
            this.targetPt = null;
        } else {
            this.targetPt = pt;
            this.targetRadius = radius;
            this.targetOrientation = orientation;
        }
        this.updateTargetDescription();
    }

    private void updateTargetDescription() {
        if (this.targetPt != null) {
            Object feature = this.describe.createDescription();
            this.describe.process(this.targetPt.x, this.targetPt.y, this.targetOrientation, this.targetRadius, feature);
            this.tuplePanel.setDescription((TupleDesc)feature);
        } else {
            this.tuplePanel.setDescription(null);
        }
        this.tuplePanel.repaint();
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        VisualizeRegionDescriptionApp app = new VisualizeRegionDescriptionApp(imageType, derivType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Cave", UtilIO.pathExample("stitch/cave_01.jpg")));
        inputs.add(new PathLabel("Kayak", UtilIO.pathExample("stitch/kayak_02.jpg")));
        inputs.add(new PathLabel("Forest", UtilIO.pathExample("scale/rainforest_01.jpg")));
        app.setPreferredSize(new Dimension(500, 500));
        app.setSize(500, 500);
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Region Descriptor Visualization", true);
    }
}

