/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.FastQueue;

public class VisualizeAssociationAlgorithmsApp<T extends ImageGray>
extends SelectAlgorithmAndInputPanel {
    DetectDescribePoint<T, TupleDesc_F64> detector;
    AssociateDescription<TupleDesc_F64> alg;
    T image0;
    T image1;
    Class<T> imageType;
    AssociationPanel panel = new AssociationPanel(20);
    boolean processedImage = false;
    FastQueue<TupleDesc_F64> features0 = new FastQueue(1, TupleDesc_F64.class, false);
    FastQueue<Point2D_F64> points0 = new FastQueue(1, Point2D_F64.class, true);
    FastQueue<TupleDesc_F64> features1 = new FastQueue(1, TupleDesc_F64.class, false);
    FastQueue<Point2D_F64> points1 = new FastQueue(1, Point2D_F64.class, true);

    public VisualizeAssociationAlgorithmsApp(Class<T> imageType) {
        super(1);
        this.imageType = imageType;
        this.detector = FactoryDetectDescribe.surfStable(new ConfigFastHessian(5.0f, 4, 200, 1, 9, 4, 4), null, null, GrayF32.class);
        int DOF = ((TupleDesc_F64)this.detector.createDescription()).size();
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        this.addAlgorithm(0, "Greedy", FactoryAssociation.greedy(score, Double.MAX_VALUE, false));
        this.addAlgorithm(0, "Greedy Backwards", FactoryAssociation.greedy(score, Double.MAX_VALUE, true));
        this.addAlgorithm(0, "K-D Tree BBF", FactoryAssociation.kdtree(DOF, 75));
        this.addAlgorithm(0, "Random Forest", FactoryAssociation.kdRandomForest(DOF, 75, 10, 5, 1233445565L));
        this.image0 = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.image1 = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.setMainGUI(this.panel);
    }

    public void process(final BufferedImage buffLeft, final BufferedImage buffRight) {
        ((ImageGray)this.image0).reshape(buffLeft.getWidth(), buffLeft.getHeight());
        ((ImageGray)this.image1).reshape(buffRight.getWidth(), buffRight.getHeight());
        ConvertBufferedImage.convertFromSingle(buffLeft, this.image0, this.imageType);
        ConvertBufferedImage.convertFromSingle(buffRight, this.image1, this.imageType);
        this.createSet(this.image0, this.features0, this.points0);
        this.createSet(this.image1, this.features1, this.points1);
        System.out.println("Found features: " + this.features0.size() + " " + this.features1.size());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeAssociationAlgorithmsApp.this.panel.setImages(buffLeft, buffRight);
                VisualizeAssociationAlgorithmsApp.this.processedImage = true;
                VisualizeAssociationAlgorithmsApp.this.doRefreshAll();
            }
        });
    }

    private void createSet(T image, FastQueue<TupleDesc_F64> descs, FastQueue<Point2D_F64> points) {
        this.detector.detect(image);
        descs.reset();
        points.reset();
        for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
            ((Point2D_F64)points.grow()).set(this.detector.getLocation(i));
            descs.add((Object)this.detector.getDescription(i).copy());
        }
    }

    public void processImages() {
        long before = System.currentTimeMillis();
        this.alg.setSource(this.features0);
        this.alg.setDestination(this.features1);
        long before1 = System.currentTimeMillis();
        this.alg.associate();
        long after = System.currentTimeMillis();
        System.out.println("Elapsed: " + (after - before) + "  or  " + (after - before1));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeAssociationAlgorithmsApp.this.panel.setAssociation(VisualizeAssociationAlgorithmsApp.this.points0.toList(), VisualizeAssociationAlgorithmsApp.this.points1.toList(), VisualizeAssociationAlgorithmsApp.this.alg.getMatches());
                VisualizeAssociationAlgorithmsApp.this.repaint();
            }
        });
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.alg = (AssociateDescription)cookies[0];
        this.processImages();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.alg = (AssociateDescription)cookie;
        this.processImages();
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage left = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(0));
        BufferedImage right = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(1));
        this.process(left, right);
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        Class<GrayF32> imageType = GrayF32.class;
        VisualizeAssociationAlgorithmsApp<GrayF32> app = new VisualizeAssociationAlgorithmsApp<GrayF32>(imageType);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Cave", UtilIO.pathExample("stitch/cave_01.jpg"), UtilIO.pathExample("stitch/cave_02.jpg")));
        inputs.add(new PathLabel("Kayak", UtilIO.pathExample("stitch/kayak_02.jpg"), UtilIO.pathExample("stitch/kayak_03.jpg")));
        inputs.add(new PathLabel("Forest", UtilIO.pathExample("scale/rainforest_01.jpg"), UtilIO.pathExample("scale/rainforest_02.jpg")));
        inputs.add(new PathLabel("Building", UtilIO.pathExample("stitch/apartment_building_01.jpg"), UtilIO.pathExample("stitch/apartment_building_02.jpg")));
        inputs.add(new PathLabel("Trees Rotate", UtilIO.pathExample("stitch/trees_rotate_01.jpg"), UtilIO.pathExample("stitch/trees_rotate_03.jpg")));
        app.setPreferredSize(new Dimension(1000, 500));
        app.setSize(1000, 500);
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Associated Features", true);
    }
}

