/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.denoise;

import boofcv.abst.denoise.WaveletDenoiseFilter;
import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.core.image.border.BorderType;
import boofcv.factory.denoise.FactoryDenoiseWaveletAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.transform.wavelet.FactoryWaveletCoiflet;
import boofcv.factory.transform.wavelet.FactoryWaveletDaub;
import boofcv.factory.transform.wavelet.FactoryWaveletHaar;
import boofcv.factory.transform.wavelet.FactoryWaveletTransform;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef_F32;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DenoiseAccuracyStudyApp {
    float noiseSigma = 20.0f;
    Random rand = new Random(2234L);
    GrayF32 image;
    GrayF32 imageNoisy;

    public void process(List<TestItem> filters, List<String> images) {
        for (String imagePath : images) {
            System.out.println("-------------------------------------------------");
            System.out.println(imagePath);
            this.loadImage(imagePath);
            this.addNoiseToImage();
            GrayF32 originalImage = (GrayF32)this.image.clone();
            GrayF32 imageDenoised = new GrayF32(this.image.width, this.image.height);
            System.out.println("  Noise MSE:  " + this.computeMSE(this.imageNoisy));
            TestItem best = null;
            double bestScore = Double.MAX_VALUE;
            for (TestItem i : filters) {
                ImageMiscOps.fill(imageDenoised, 0.0f);
                i.filter.process(this.imageNoisy, imageDenoised);
                if (ImageStatistics.meanDiffSq(this.image, originalImage) != 0.0) {
                    throw new RuntimeException("Filter modified input image");
                }
                double error = this.computeMSE(imageDenoised);
                double errorEdge = this.computeEdgeMSE(imageDenoised);
                System.out.printf("%30s  MSE = %8.3f  Edge MSE = %8.3f\n", i.name, error, errorEdge);
                if (!(bestScore > error)) continue;
                bestScore = error;
                best = i;
            }
            System.out.println("Best Filter: " + best.name);
        }
    }

    public static List<TestItem> createStandard(int minLevel, int maxLevel) {
        ArrayList<TestItem> ret = new ArrayList<TestItem>();
        ret.addAll(DenoiseAccuracyStudyApp.addSpacial());
        for (int numLevels = minLevel; numLevels <= maxLevel; ++numLevels) {
            ret.addAll(DenoiseAccuracyStudyApp.createWaveletFilters(FactoryWaveletHaar.generate(false, 32), numLevels, "Haar"));
            ret.addAll(DenoiseAccuracyStudyApp.createWaveletFilters(FactoryWaveletDaub.daubJ_F32(4), numLevels, "Daub-4"));
            ret.addAll(DenoiseAccuracyStudyApp.createWaveletFilters(FactoryWaveletCoiflet.generate_F32(6), numLevels, "Coiflet-6"));
            ret.addAll(DenoiseAccuracyStudyApp.createWaveletFilters(FactoryWaveletDaub.biorthogonal_F32(5, BorderType.WRAP), numLevels, "Biorthogonal-5"));
        }
        return ret;
    }

    protected static List<TestItem> createWaveletFilters(WaveletDescription<WlCoef_F32> waveletDesc, int numLevels, String waveletName) {
        ArrayList<TestItem> ret = new ArrayList<TestItem>();
        WaveletTransform<GrayF32, GrayF32, WlCoef_F32> waveletTran = FactoryWaveletTransform.create_F32(waveletDesc, numLevels, 0.0f, 255.0f);
        WaveletDenoiseFilter<GrayF32> filter = new WaveletDenoiseFilter<GrayF32>(waveletTran, FactoryDenoiseWaveletAlg.visu(GrayF32.class));
        ret.add(new TestItem(filter, "Visu " + waveletName + " L = " + numLevels));
        filter = new WaveletDenoiseFilter<GrayF32>(waveletTran, FactoryDenoiseWaveletAlg.bayes(null, GrayF32.class));
        ret.add(new TestItem(filter, "Bayes " + waveletName + " L = " + numLevels));
        filter = new WaveletDenoiseFilter<GrayF32>(waveletTran, FactoryDenoiseWaveletAlg.sure(GrayF32.class));
        ret.add(new TestItem(filter, "Sure " + waveletName + " L = " + numLevels));
        return ret;
    }

    protected static List<TestItem> addSpacial() {
        ArrayList<TestItem> ret = new ArrayList<TestItem>();
        BlurStorageFilter<GrayF32> filter = FactoryBlurFilter.gaussian(GrayF32.class, -1.0, 2);
        ret.add(new TestItem(filter, "Gaussian 2"));
        filter = FactoryBlurFilter.gaussian(GrayF32.class, -1.0, 3);
        ret.add(new TestItem(filter, "Gaussian 3"));
        filter = FactoryBlurFilter.mean(GrayF32.class, 2);
        ret.add(new TestItem(filter, "Mean 2"));
        filter = FactoryBlurFilter.mean(GrayF32.class, 3);
        ret.add(new TestItem(filter, "Mean 3"));
        filter = FactoryBlurFilter.median(GrayF32.class, 2);
        ret.add(new TestItem(filter, "Median 2"));
        filter = FactoryBlurFilter.median(GrayF32.class, 3);
        ret.add(new TestItem(filter, "Median 3"));
        return ret;
    }

    private double computeMSE(GrayF32 imageInv) {
        return ImageStatistics.meanDiffSq(imageInv, this.image);
    }

    private double computeEdgeMSE(GrayF32 imageInv) {
        GrayF32 edge = new GrayF32(imageInv.width, imageInv.height);
        LaplacianEdge.process(this.image, edge);
        PixelMath.abs(edge, edge);
        float max = ImageStatistics.maxAbs(edge);
        PixelMath.divide(edge, max, edge);
        float total = ImageStatistics.sum(edge);
        double error = 0.0;
        for (int y = 0; y < this.image.height; ++y) {
            for (int x = 0; x < this.image.width; ++x) {
                double w = edge.get(x, y) / total;
                double e = this.image.get(x, y) - imageInv.get(x, y);
                error += e * e * w;
            }
        }
        return error;
    }

    private void loadImage(String imagePath) {
        BufferedImage in = UtilImageIO.loadImage(imagePath);
        this.image = ConvertBufferedImage.convertFrom(in, (GrayF32)null);
    }

    private void addNoiseToImage() {
        this.imageNoisy = (GrayF32)this.image.clone();
        ImageMiscOps.addGaussian(this.imageNoisy, this.rand, (double)this.noiseSigma, 0.0f, 255.0f);
    }

    public static void main(String[] args) {
        DenoiseAccuracyStudyApp app = new DenoiseAccuracyStudyApp();
        String path = UtilIO.pathExample("standard/");
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(path + "barbara.jpg");
        fileNames.add(path + "lena512.jpg");
        fileNames.add(path + "peppers256.jpg");
        fileNames.add(path + "boat.jpg");
        fileNames.add(path + "house.png");
        app.process(DenoiseAccuracyStudyApp.createStandard(2, 4), fileNames);
    }

    public static class TestItem {
        public FilterImageInterface<GrayF32, GrayF32> filter;
        public String name;
        public double opsPerSecond;

        public TestItem(FilterImageInterface<GrayF32, GrayF32> filter, String name) {
            this.filter = filter;
            this.name = name;
        }
    }
}

