/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.demonstrations.calibration.BaseCalibrationConfig;
import boofcv.io.MediaManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ParseMonoCalibrationConfig
extends BaseCalibrationConfig {
    public List<String> images = new ArrayList<String>();

    public ParseMonoCalibrationConfig(MediaManager media) {
        this.media = media;
    }

    public ParseMonoCalibrationConfig() {
    }

    public boolean parse(String fileName) {
        Reader input = this.media.openFile(fileName);
        if (input == null) {
            return false;
        }
        BufferedReader reader = new BufferedReader(input);
        String infoFile = null;
        this.images.clear();
        try {
            String line = reader.readLine();
            while (line != null && line.charAt(0) == '#') {
                line = reader.readLine();
            }
            if (line == null) {
                return false;
            }
            String[] v = line.split("\\s");
            if (v.length != 3) {
                return false;
            }
            infoFile = v[2];
            while ((line = reader.readLine()) != null) {
                v = line.split("\\s");
                if (v.length != 3) continue;
                this.images.add(v[2]);
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        if (infoFile == null || this.images.size() == 0) {
            return false;
        }
        try {
            this.parseTarget(infoFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public List<String> getImages() {
        return this.images;
    }
}

