/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.alg.fiducial.calib.chess.DetectChessboardFiducial;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.filter.binary.Contour;
import boofcv.demonstrations.calibration.CommonDetectCalibrationApp;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectCalibrationChessboardApp
extends CommonDetectCalibrationApp {
    DetectChessboardFiducial<GrayF32> alg;
    ConfigChessboard config;

    public DetectCalibrationChessboardApp(int numRows, int numColumns, boolean forCalibration, List<String> exampleInputs) {
        super(numRows, numColumns, exampleInputs);
        this.config = new ConfigChessboard(numRows, numColumns, 1.0);
        this.config.refineWithCorners = forCalibration;
        this.declareDetector();
    }

    @Override
    public void declareDetector() {
        if (this.controlPanel.isManual()) {
            this.config.thresholding.type = ThresholdType.FIXED;
            this.config.thresholding.fixedThreshold = this.controlPanel.getThresholdLevel();
        } else {
            this.config.thresholding.type = ThresholdType.LOCAL_SQUARE_BLOCK_MIN_MAX;
        }
        this.config.numRows = this.controlPanel.getGridRows();
        this.config.numCols = this.controlPanel.getGridColumns();
        this.alg = FactoryCalibrationTarget.detectorChessboard(this.config).getAlgorithm();
    }

    @Override
    protected boolean process(GrayF32 image) {
        return this.alg.process(image);
    }

    @Override
    protected GrayU8 getBinaryImage() {
        return this.alg.getBinary();
    }

    @Override
    protected List<List<SquareNode>> getClusters() {
        return this.alg.getFindSeeds().getGraphs();
    }

    @Override
    protected List<Point2D_F64> getCalibrationPoints() {
        return this.alg.getCalibrationPoints();
    }

    @Override
    protected List<Contour> getContours() {
        return this.alg.getFindSeeds().getDetectorSquare().getAllContours();
    }

    @Override
    protected FastQueue<Polygon2D_F64> getFoundPolygons() {
        return this.alg.getFindSeeds().getDetectorSquare().getFoundPolygons();
    }

    @Override
    protected List<SquareGrid> getGrids() {
        return this.alg.getFindSeeds().getGrids().getGrids().toList();
    }

    public void configure(int numRows, int numCols, boolean forCalibration) {
        this.config = new ConfigChessboard(numRows, numCols, 1.0);
        this.config.refineWithCorners = forCalibration;
    }

    public static void main(String[] args) throws FileNotFoundException {
        ArrayList<String> examples = new ArrayList<String>();
        for (int i = 1; i <= 11; ++i) {
            examples.add(UtilIO.pathExample(String.format("calibration/stereo/Bumblebee2_Chess/left%02d.jpg", i)));
        }
        DetectCalibrationChessboardApp app = new DetectCalibrationChessboardApp(7, 5, false, examples);
        app.openFile(new File((String)examples.get(0)));
        app.waitUntilDoneProcessing();
        ShowImages.showWindow(app, "Calibration Target Detection", true);
    }
}

