/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DemoThresholdingPanel
extends StandardAlgConfigPanel
implements ActionListener,
ChangeListener {
    JComboBox comboSelect;
    JButton directionButton;
    JSlider thresholdLevel;
    JSpinner spinnerRadius;
    JSpinner spinnerScale;
    Listener listener;
    int valueThreshold;
    boolean directionDown;
    int threshRadius;
    double scale;

    public DemoThresholdingPanel(int threshold, boolean directionDown, int radius, double scale, Listener listener) {
        this.listener = listener;
        this.valueThreshold = threshold;
        this.directionDown = directionDown;
        this.threshRadius = radius;
        this.scale = scale;
        String[] algStrings = new String[]{"Fixed", "Global Otsu", "Global Entropy", "Local Square", "Local Gaussian", "Local Sauvola", "Local Block Min-Max"};
        this.comboSelect = new JComboBox<String>(algStrings);
        this.comboSelect.addActionListener(this);
        this.comboSelect.setMaximumSize(this.comboSelect.getPreferredSize());
        this.directionButton = new JButton();
        this.directionButton.setPreferredSize(new Dimension(100, 30));
        this.directionButton.setMaximumSize(this.directionButton.getPreferredSize());
        this.directionButton.setMinimumSize(this.directionButton.getPreferredSize());
        this.setToggleText(directionDown);
        this.directionButton.addActionListener(this);
        this.thresholdLevel = new JSlider(0, 0, 255, this.valueThreshold);
        this.thresholdLevel.setMajorTickSpacing(20);
        this.thresholdLevel.setPaintTicks(true);
        this.thresholdLevel.addChangeListener(this);
        this.thresholdLevel.setValue(threshold);
        this.spinnerRadius = new JSpinner(new SpinnerNumberModel(this.threshRadius, 5, 200, 10));
        this.spinnerRadius.addChangeListener(this);
        this.spinnerRadius.setMaximumSize(this.spinnerRadius.getPreferredSize());
        this.spinnerScale = new JSpinner(new SpinnerNumberModel(scale, 0.0, 2.0, 0.01));
        this.spinnerScale.addChangeListener(this);
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.spinnerScale.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(2);
        format.setMinimumIntegerDigits(1);
        Dimension d = this.spinnerScale.getPreferredSize();
        d.width = 60;
        this.spinnerScale.setPreferredSize(d);
        this.spinnerScale.setMaximumSize(d);
        this.updateActive(this.comboSelect.getSelectedIndex());
        this.add(this.comboSelect);
        this.addSeparator(100);
        this.addAlignLeft(this.directionButton, this);
        this.addAlignLeft(this.thresholdLevel, this);
        this.addLabeled(this.spinnerRadius, "Radius", this);
        this.addLabeled(this.spinnerScale, "Scale", this);
        this.add(Box.createVerticalGlue());
    }

    private void setToggleText(boolean direction) {
        if (direction) {
            this.directionButton.setText("down");
        } else {
            this.directionButton.setText("Up");
        }
    }

    protected void updateActive(int which) {
        if (which == 0) {
            this.thresholdLevel.setEnabled(true);
            this.spinnerRadius.setEnabled(false);
            this.spinnerScale.setEnabled(false);
        } else {
            this.thresholdLevel.setEnabled(false);
            this.spinnerRadius.setEnabled(true);
            this.spinnerScale.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboSelect) {
            this.updateActive(this.comboSelect.getSelectedIndex());
            this.listener.changeSelected(this.comboSelect.getSelectedIndex());
        } else if (e.getSource() == this.directionButton) {
            this.directionDown = !this.directionDown;
            this.setToggleText(this.directionDown);
            this.listener.settingChanged();
        }
    }

    public boolean getDirection() {
        return this.directionDown;
    }

    public int getValueThreshold() {
        return this.valueThreshold;
    }

    public int getThreshRadius() {
        return this.threshRadius;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.thresholdLevel) {
            this.valueThreshold = this.thresholdLevel.getValue();
            this.listener.settingChanged();
        } else if (e.getSource() == this.spinnerRadius) {
            this.threshRadius = ((Number)this.spinnerRadius.getValue()).intValue();
            this.listener.settingChanged();
        } else if (e.getSource() == this.spinnerScale) {
            this.scale = ((Number)this.spinnerScale.getValue()).doubleValue();
            this.listener.settingChanged();
        }
    }

    public static interface Listener {
        public void changeSelected(int var1);

        public void settingChanged();
    }
}

