/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.geometry.UtilPoint2D_F32;
import georegression.struct.shapes.Rectangle2D_F64;
import java.lang.reflect.Array;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastQueue;

public class TldRegionTracker<Image extends ImageGray, Derivative extends ImageGray> {
    private double maxErrorFB;
    private ImagePyramid<Image> currentImage;
    private Derivative[] currentDerivX;
    private Derivative[] currentDerivY;
    private ImagePyramid<Image> previousImage;
    private Derivative[] previousDerivX;
    private Derivative[] previousDerivY;
    private Class<Derivative> derivType;
    private ImageGradient<Image, Derivative> gradient;
    private int numPyramidLayers;
    private PyramidKltTracker<Image, Derivative> tracker;
    private Track[] tracks;
    private FastQueue<AssociatedPair> pairs = new FastQueue(AssociatedPair.class, true);
    private double[] errorsFB;
    private int gridWidth;
    private int featureRadius;
    private Rectangle2D_F64 spawnRect = new Rectangle2D_F64();

    public TldRegionTracker(int gridWidth, int featureRadius, double maxErrorFB, ImageGradient<Image, Derivative> gradient, PyramidKltTracker<Image, Derivative> tracker, Class<Image> imageType, Class<Derivative> derivType) {
        this.gridWidth = gridWidth;
        this.featureRadius = featureRadius;
        this.maxErrorFB = maxErrorFB;
        this.tracker = tracker;
        this.gradient = gradient;
        this.derivType = derivType;
        this.tracks = new Track[gridWidth * gridWidth];
        this.errorsFB = new double[gridWidth * gridWidth];
    }

    public void initialize(PyramidDiscrete<Image> image) {
        if (this.previousDerivX == null || this.previousDerivX.length != image.getNumLayers() || this.previousImage.getInputWidth() != image.getInputWidth() || this.previousImage.getInputHeight() != image.getInputHeight()) {
            this.declareDataStructures(image);
        }
        for (int i = 0; i < image.getNumLayers(); ++i) {
            this.gradient.process(image.getLayer(i), this.previousDerivX[i], this.previousDerivY[i]);
        }
        this.previousImage.setTo(image);
    }

    protected void declareDataStructures(PyramidDiscrete<Image> image) {
        int i;
        this.numPyramidLayers = image.getNumLayers();
        this.previousDerivX = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        this.previousDerivY = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        this.currentDerivX = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        this.currentDerivY = (ImageGray[])Array.newInstance(this.derivType, image.getNumLayers());
        for (i = 0; i < image.getNumLayers(); ++i) {
            int w = image.getWidth(i);
            int h = image.getHeight(i);
            this.previousDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.previousDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.currentDerivX[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
            this.currentDerivY[i] = GeneralizedImageOps.createSingleBand(this.derivType, w, h);
        }
        this.previousImage = FactoryPyramid.discreteGaussian(image.getScales(), -1.0, 1, false, image.getImageType());
        this.previousImage.initialize(image.getInputWidth(), image.getInputHeight());
        for (i = 0; i < this.tracks.length; ++i) {
            Track t = new Track();
            t.klt = new PyramidKltFeature(this.numPyramidLayers, this.featureRadius);
            this.tracks[i] = t;
        }
    }

    public boolean process(ImagePyramid<Image> image, Rectangle2D_F64 targetRectangle) {
        boolean success = true;
        this.updateCurrent(image);
        this.spawnGrid(targetRectangle);
        if (!this.trackFeature()) {
            success = false;
        }
        this.setCurrentToPrevious();
        return success;
    }

    protected void updateCurrent(ImagePyramid<Image> image) {
        this.currentImage = image;
        for (int i = 0; i < image.getNumLayers(); ++i) {
            this.gradient.process(image.getLayer(i), this.currentDerivX[i], this.currentDerivY[i]);
        }
    }

    private void setCurrentToPrevious() {
        this.previousImage.setTo(this.currentImage);
        Derivative[] tmp = this.previousDerivX;
        this.previousDerivX = this.currentDerivX;
        this.currentDerivX = tmp;
        tmp = this.previousDerivY;
        this.previousDerivY = this.currentDerivY;
        this.currentDerivY = tmp;
    }

    protected boolean trackFeature() {
        this.pairs.reset();
        int numTracksFB = 0;
        int numTracksRemaining = 0;
        for (int i = 0; i < this.tracks.length; ++i) {
            Track t = this.tracks[i];
            if (!t.active) continue;
            float prevX = t.klt.x;
            float prevY = t.klt.y;
            this.tracker.setImage(this.currentImage, (ImageGray[])this.currentDerivX, (ImageGray[])this.currentDerivY);
            KltTrackFault result = this.tracker.track(t.klt);
            if (result != KltTrackFault.SUCCESS) {
                t.active = false;
                continue;
            }
            float currX = t.klt.x;
            float currY = t.klt.y;
            this.tracker.setDescription(t.klt);
            this.tracker.setImage(this.previousImage, (ImageGray[])this.previousDerivX, (ImageGray[])this.previousDerivY);
            result = this.tracker.track(t.klt);
            if (result != KltTrackFault.SUCCESS) {
                t.active = false;
                continue;
            }
            double errorForwardBackwards = UtilPoint2D_F32.distanceSq((float)prevX, (float)prevY, (float)t.klt.x, (float)t.klt.y);
            this.errorsFB[numTracksFB++] = errorForwardBackwards;
            if (errorForwardBackwards > this.maxErrorFB) {
                t.active = false;
                continue;
            }
            AssociatedPair p = (AssociatedPair)this.pairs.grow();
            p.p1.set((double)prevX, (double)prevY);
            p.p2.set((double)currX, (double)currY);
            ++numTracksRemaining;
        }
        double medianFB = QuickSelect.select((double[])this.errorsFB, (int)(numTracksFB / 2), (int)numTracksFB);
        return !(medianFB > this.maxErrorFB) && numTracksRemaining >= 4;
    }

    protected void spawnGrid(Rectangle2D_F64 prevRect) {
        this.spawnRect.p0.x = prevRect.p0.x + (double)this.featureRadius;
        this.spawnRect.p0.y = prevRect.p0.y + (double)this.featureRadius;
        this.spawnRect.p1.x = prevRect.p1.x - (double)this.featureRadius;
        this.spawnRect.p1.y = prevRect.p1.y - (double)this.featureRadius;
        double spawnWidth = this.spawnRect.getWidth();
        double spawnHeight = this.spawnRect.getHeight();
        this.tracker.setImage(this.previousImage, (ImageGray[])this.previousDerivX, (ImageGray[])this.previousDerivY);
        for (int i = 0; i < this.gridWidth; ++i) {
            float y = (float)(this.spawnRect.p0.y + (double)i * spawnHeight / (double)(this.gridWidth - 1));
            for (int j = 0; j < this.gridWidth; ++j) {
                float x = (float)(this.spawnRect.p0.x + (double)j * spawnWidth / (double)(this.gridWidth - 1));
                Track t = this.tracks[i * this.gridWidth + j];
                t.klt.x = x;
                t.klt.y = y;
                t.active = this.tracker.setDescription(t.klt);
            }
        }
    }

    public FastQueue<AssociatedPair> getPairs() {
        return this.pairs;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public static class Track {
        PyramidKltFeature klt;
        boolean active;
    }
}

