/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.edge.BaseIntegralEdge;
import boofcv.core.image.GImageGrayDistorted;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;

public class ScoreLineSegmentEdge<T extends ImageGray>
extends BaseIntegralEdge<T> {
    int numSamples;
    int samplesInside;
    double averageUp;
    double averageDown;

    public ScoreLineSegmentEdge(int numSamples, Class<T> imageType) {
        super(imageType);
        this.numSamples = numSamples;
    }

    @Override
    public void setTransform(PixelTransform_F32 undistToDist) {
        InterpolatePixelS interpolate = FactoryInterpolation.bilinearPixelS(this.imageType, BorderType.EXTENDED);
        this.integralImage = new GImageGrayDistorted(undistToDist, interpolate);
    }

    @Override
    public void setImage(T image) {
        this.integralImage.wrap((ImageGray)image);
        this.integral.setImage(this.integralImage);
    }

    public double computeAverageDerivative(Point2D_F64 a, Point2D_F64 b, double tanX, double tanY) {
        this.samplesInside = 0;
        this.averageDown = 0.0;
        this.averageUp = 0.0;
        for (int i = 0; i < this.numSamples; ++i) {
            double x = (b.x - a.x) * (double)i / (double)(this.numSamples - 1) + a.x;
            double y = (b.y - a.y) * (double)i / (double)(this.numSamples - 1) + a.y;
            double x0 = x + tanX;
            double y0 = y + tanY;
            if (!BoofMiscOps.checkInside(this.integralImage.getWidth(), this.integralImage.getHeight(), x0, y0)) continue;
            double x1 = x - tanX;
            double y1 = y - tanY;
            if (!BoofMiscOps.checkInside(this.integralImage.getWidth(), this.integralImage.getHeight(), x1, y1)) continue;
            ++this.samplesInside;
            double up = this.integral.compute(x, y, x0, y0);
            double down = this.integral.compute(x, y, x1, y1);
            this.averageUp += up;
            this.averageDown += down;
        }
        if (this.samplesInside == 0) {
            return 0.0;
        }
        this.averageUp /= (double)this.samplesInside;
        this.averageDown /= (double)this.samplesInside;
        return this.averageUp - this.averageDown;
    }

    public int getSamplesInside() {
        return this.samplesInside;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public double getAverageUp() {
        return this.averageUp;
    }

    public double getAverageDown() {
        return this.averageDown;
    }
}

