/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class SegmentMeanShiftSearch<T extends ImageBase> {
    protected int maxIterations;
    protected float convergenceTol;
    protected int radiusX;
    protected int radiusY;
    protected int widthX;
    protected int widthY;
    protected float maxColorDistanceSq;
    protected GrayS32 pixelToMode = new GrayS32(1, 1);
    protected GrayS32 quickMode = new GrayS32(1, 1);
    protected FastQueue<Point2D_I32> modeLocation = new FastQueue(Point2D_I32.class, true);
    protected GrowQueue_I32 modeMemberCount = new GrowQueue_I32();
    protected FastQueue<float[]> modeColor;
    protected float[] spacialTable;
    protected float[] weightTable = new float[100];
    boolean fast;
    protected T image;
    protected float modeX;
    protected float modeY;

    public SegmentMeanShiftSearch(int maxIterations, float convergenceTol, int radiusX, int radiusY, float maxColorDistance, boolean fast) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.fast = fast;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.widthX = radiusX * 2 + 1;
        this.widthY = radiusY * 2 + 1;
        this.maxColorDistanceSq = maxColorDistance * maxColorDistance;
        this.spacialTable = new float[this.widthX * this.widthY];
        int indexKernel = 0;
        float maxRadius = radiusX * radiusX + radiusY * radiusY;
        for (int y = -radiusY; y <= radiusY; ++y) {
            for (int x = -radiusX; x <= radiusX; ++x) {
                this.spacialTable[indexKernel++] = (float)(x * x + y * y) / maxRadius;
            }
        }
        for (int i = 0; i < this.weightTable.length; ++i) {
            this.weightTable[i] = (float)Math.exp((float)(-i) / (float)(this.weightTable.length - 1));
        }
    }

    public abstract void process(T var1);

    public static float distanceSq(float[] a, float[] b) {
        float ret = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            float d = a[i] - b[i];
            ret += d * d;
        }
        return ret;
    }

    protected float weight(float distance) {
        float findex = distance * 100.0f;
        int index = (int)findex;
        if (index >= 99) {
            return this.weightTable[99];
        }
        float sample0 = this.weightTable[index];
        float sample1 = this.weightTable[index + 1];
        float w = findex - (float)index;
        return sample0 * (1.0f - w) + sample1 * w;
    }

    public GrayS32 getPixelToRegion() {
        return this.pixelToMode;
    }

    public FastQueue<Point2D_I32> getModeLocation() {
        return this.modeLocation;
    }

    public GrowQueue_I32 getRegionMemberCount() {
        return this.modeMemberCount;
    }

    public FastQueue<float[]> getModeColor() {
        return this.modeColor;
    }

    public abstract ImageType<T> getImageType();
}

