/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.ms;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.segmentation.ms.RegionMergeTree;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.GrowQueue_I32;

public class ClusterLabeledImage
extends RegionMergeTree {
    protected ConnectRule connectRule;
    protected int[] edgesIn;
    protected int[] edgesOut;
    protected Point2D_I32[] edges;
    protected GrowQueue_I32 regionMemberCount;

    public ClusterLabeledImage(ConnectRule connectRule) {
        this.connectRule = connectRule;
        if (connectRule == ConnectRule.EIGHT) {
            this.edgesIn = new int[4];
            this.edgesOut = new int[4];
            this.edges = new Point2D_I32[4];
        } else if (connectRule == ConnectRule.FOUR) {
            this.edgesIn = new int[2];
            this.edgesOut = new int[2];
            this.edges = new Point2D_I32[2];
        } else {
            throw new IllegalArgumentException("connectRule must be 4 or 8");
        }
        for (int i = 0; i < this.edges.length; ++i) {
            this.edges[i] = new Point2D_I32();
        }
    }

    protected void setUpEdges(GrayS32 input, GrayS32 output) {
        if (this.connectRule == ConnectRule.EIGHT) {
            this.setUpEdges8(input, this.edgesIn);
            this.setUpEdges8(output, this.edgesOut);
            this.edges[0].set(1, 0);
            this.edges[1].set(1, 1);
            this.edges[2].set(0, 1);
            this.edges[3].set(-1, 0);
        } else {
            this.setUpEdges4(input, this.edgesIn);
            this.setUpEdges4(output, this.edgesOut);
            this.edges[0].set(1, 0);
            this.edges[1].set(0, 1);
        }
    }

    protected void setUpEdges8(GrayS32 image, int[] edges) {
        edges[0] = 1;
        edges[1] = 1 + image.stride;
        edges[2] = image.stride;
        edges[3] = -1 + image.stride;
    }

    protected void setUpEdges4(GrayS32 image, int[] edges) {
        edges[0] = 1;
        edges[1] = image.stride;
    }

    public void process(GrayS32 input, GrayS32 output, GrowQueue_I32 regionMemberCount) {
        this.regionMemberCount = regionMemberCount;
        regionMemberCount.reset();
        this.setUpEdges(input, output);
        ImageMiscOps.fill(output, -1);
        this.mergeList.reset();
        this.connectInner(input, output);
        this.connectLeftRight(input, output);
        this.connectBottom(input, output);
        this.performMerge(output, regionMemberCount);
    }

    protected void connectInner(GrayS32 input, GrayS32 output) {
        int startX = this.connectRule == ConnectRule.EIGHT ? 1 : 0;
        for (int y = 0; y < input.height - 1; ++y) {
            int indexIn = input.startIndex + y * input.stride + startX;
            int indexOut = output.startIndex + y * output.stride + startX;
            int x = startX;
            while (x < input.width - 1) {
                int inputLabel = input.data[indexIn];
                int outputLabel = output.data[indexOut];
                if (outputLabel == -1) {
                    output.data[indexOut] = outputLabel = this.regionMemberCount.size;
                    this.regionMemberCount.add(1);
                    this.mergeList.add(outputLabel);
                }
                for (int i = 0; i < this.edgesIn.length; ++i) {
                    if (inputLabel != input.data[indexIn + this.edgesIn[i]]) continue;
                    int outputAdj = output.data[indexOut + this.edgesOut[i]];
                    if (outputAdj == -1) {
                        int n = outputLabel;
                        this.regionMemberCount.data[n] = this.regionMemberCount.data[n] + 1;
                        output.data[indexOut + this.edgesOut[i]] = outputLabel;
                        continue;
                    }
                    if (outputLabel == outputAdj) continue;
                    this.markMerge(outputLabel, outputAdj);
                }
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    protected void connectLeftRight(GrayS32 input, GrayS32 output) {
        for (int y = 0; y < input.height; ++y) {
            int outputAdj;
            Point2D_I32 offset;
            int i;
            int x = input.width - 1;
            int inputLabel = input.unsafe_get(x, y);
            int outputLabel = output.unsafe_get(x, y);
            if (outputLabel == -1) {
                outputLabel = this.regionMemberCount.size;
                output.unsafe_set(x, y, outputLabel);
                this.regionMemberCount.add(1);
                this.mergeList.add(outputLabel);
            }
            for (i = 0; i < this.edges.length; ++i) {
                offset = this.edges[i];
                if (!input.isInBounds(x + offset.x, y + offset.y) || inputLabel != input.unsafe_get(x + offset.x, y + offset.y)) continue;
                outputAdj = output.unsafe_get(x + offset.x, y + offset.y);
                if (outputAdj == -1) {
                    int n = outputLabel;
                    this.regionMemberCount.data[n] = this.regionMemberCount.data[n] + 1;
                    output.unsafe_set(x + offset.x, y + offset.y, outputLabel);
                    continue;
                }
                if (outputLabel == outputAdj) continue;
                this.markMerge(outputLabel, outputAdj);
            }
            if (this.connectRule != ConnectRule.EIGHT) continue;
            x = 0;
            inputLabel = input.unsafe_get(x, y);
            outputLabel = output.unsafe_get(x, y);
            if (outputLabel == -1) {
                outputLabel = this.regionMemberCount.size;
                output.unsafe_set(x, y, outputLabel);
                this.regionMemberCount.add(1);
                this.mergeList.add(outputLabel);
            }
            for (i = 0; i < this.edges.length; ++i) {
                offset = this.edges[i];
                if (!input.isInBounds(x + offset.x, y + offset.y) || inputLabel != input.unsafe_get(x + offset.x, y + offset.y)) continue;
                outputAdj = output.unsafe_get(x + offset.x, y + offset.y);
                if (outputAdj == -1) {
                    int n = outputLabel;
                    this.regionMemberCount.data[n] = this.regionMemberCount.data[n] + 1;
                    output.unsafe_set(x + offset.x, y + offset.y, outputLabel);
                    continue;
                }
                if (outputLabel == outputAdj) continue;
                this.markMerge(outputLabel, outputAdj);
            }
        }
    }

    protected void connectBottom(GrayS32 input, GrayS32 output) {
        for (int x = 0; x < input.width - 1; ++x) {
            int y = input.height - 1;
            int inputLabel = input.unsafe_get(x, y);
            int outputLabel = output.unsafe_get(x, y);
            if (outputLabel == -1) {
                outputLabel = this.regionMemberCount.size;
                output.unsafe_set(x, y, outputLabel);
                this.regionMemberCount.add(1);
                this.mergeList.add(outputLabel);
            }
            if (inputLabel != input.unsafe_get(x + 1, y)) continue;
            int outputAdj = output.unsafe_get(x + 1, y);
            if (outputAdj == -1) {
                int n = outputLabel;
                this.regionMemberCount.data[n] = this.regionMemberCount.data[n] + 1;
                output.unsafe_set(x + 1, y, outputLabel);
                continue;
            }
            if (outputLabel == outputAdj) continue;
            this.markMerge(outputLabel, outputAdj);
        }
    }
}

