/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixelMB;
import boofcv.core.image.border.ImageBorder_IL_F64;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF64;

public class ImplBilinearPixel_IL_F64
extends BilinearPixelMB<InterleavedF64> {
    double[] temp0;
    double[] temp1;
    double[] temp2;
    double[] temp3;

    public ImplBilinearPixel_IL_F64(int numBands) {
        this.temp0 = new double[numBands];
        this.temp1 = new double[numBands];
        this.temp2 = new double[numBands];
        this.temp3 = new double[numBands];
    }

    public ImplBilinearPixel_IL_F64(InterleavedF64 orig) {
        this(orig.getNumBands());
        this.setImage(orig);
    }

    @Override
    public void setImage(InterleavedF64 image) {
        if (image.getNumBands() != this.temp0.length) {
            throw new IllegalArgumentException("Number of bands doesn't match");
        }
        super.setImage(image);
    }

    @Override
    public void get_fast(float x, float y, float[] values) {
        int xt = (int)x;
        int yt = (int)y;
        double ax = x - (float)xt;
        double ay = y - (float)yt;
        int numBands = ((InterleavedF64)this.orig).numBands;
        int index = ((InterleavedF64)this.orig).startIndex + yt * this.stride + xt * numBands;
        double[] data = ((InterleavedF64)this.orig).data;
        double a00 = (1.0 - ax) * (1.0 - ay);
        double a10 = ax * (1.0 - ay);
        double a11 = ax * ay;
        double a01 = (1.0 - ax) * ay;
        for (int i = 0; i < numBands; ++i) {
            int indexBand = index + i;
            double val = a00 * data[indexBand];
            val += a10 * data[indexBand + numBands];
            val += a11 * data[indexBand + numBands + this.stride];
            values[i] = (float)(val += a01 * data[indexBand + this.stride]);
        }
    }

    public void get_border(float x, float y, float[] values) {
        float xf = (float)Math.floor(x);
        float yf = (float)Math.floor(y);
        int xt = (int)xf;
        int yt = (int)yf;
        float ax = x - xf;
        float ay = y - yf;
        ImageBorder_IL_F64 border = (ImageBorder_IL_F64)this.border;
        border.get(xt, yt, this.temp0);
        border.get(xt + 1, yt, this.temp1);
        border.get(xt + 1, yt + 1, this.temp2);
        border.get(xt, yt + 1, this.temp3);
        int numBands = ((InterleavedF64)this.orig).numBands;
        for (int i = 0; i < numBands; ++i) {
            float val = (1.0f - ax) * (1.0f - ay) * (float)this.temp0[i];
            val += ax * (1.0f - ay) * (float)this.temp1[i];
            val += ax * ay * (float)this.temp2[i];
            values[i] = val += (1.0f - ax) * ay * (float)this.temp3[i];
        }
    }

    @Override
    public void get(float x, float y, float[] values) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 2) || y > (float)(this.height - 2)) {
            this.get_border(x, y, values);
        } else {
            this.get_fast(x, y, values);
        }
    }

    @Override
    public ImageType<InterleavedF64> getImageType() {
        return ((InterleavedF64)this.orig).getImageType();
    }
}

