/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.struct.image.GrayF32;

public class BilinearRectangle_F32
implements InterpolateRectangle<GrayF32> {
    private GrayF32 orig;
    private float[] data;
    private int stride;

    public BilinearRectangle_F32(GrayF32 image) {
        this.setImage(image);
    }

    public BilinearRectangle_F32() {
    }

    @Override
    public void setImage(GrayF32 image) {
        this.orig = image;
        this.data = this.orig.data;
        this.stride = this.orig.getStride();
    }

    @Override
    public GrayF32 getImage() {
        return this.orig;
    }

    @Override
    public void region(float tl_x, float tl_y, GrayF32 output) {
        if (tl_x < 0.0f || tl_y < 0.0f || tl_x + (float)output.width > (float)this.orig.width || tl_y + (float)output.height > (float)this.orig.height) {
            throw new IllegalArgumentException("Region is outside of the image");
        }
        int xt = (int)tl_x;
        int yt = (int)tl_y;
        float ax = tl_x - (float)xt;
        float ay = tl_y - (float)yt;
        float bx = 1.0f - ax;
        float by = 1.0f - ay;
        float a0 = bx * by;
        float a1 = ax * by;
        float a2 = ax * ay;
        float a3 = bx * ay;
        int regWidth = output.width;
        int regHeight = output.height;
        float[] results = output.data;
        boolean borderRight = false;
        boolean borderBottom = false;
        if (xt + regWidth >= this.orig.width || yt + regHeight >= this.orig.height) {
            if (xt + regWidth > this.orig.width || yt + regHeight > this.orig.height) {
                throw new IllegalArgumentException("requested region is out of bounds");
            }
            if (xt + regWidth == this.orig.width) {
                --regWidth;
                borderRight = true;
            }
            if (yt + regHeight == this.orig.height) {
                --regHeight;
                borderBottom = true;
            }
        }
        for (int i = 0; i < regHeight; ++i) {
            int index;
            int indexResults = output.startIndex + i * output.stride;
            float XY = this.data[index];
            float Xy = this.data[index + this.stride];
            int indexEnd = index + regWidth;
            for (index = this.orig.startIndex + (yt + i) * this.stride + xt; index < indexEnd; ++index) {
                float xY = this.data[index + 1];
                float xy = this.data[index + this.stride + 1];
                float val = a0 * XY + a1 * xY + a2 * xy + a3 * Xy;
                results[indexResults++] = val;
                XY = xY;
                Xy = xy;
            }
        }
        if (borderBottom || borderRight) {
            this.handleBorder(output, xt, yt, ax, ay, bx, by, regWidth, regHeight, results, borderRight, borderBottom);
        }
    }

    private void handleBorder(GrayF32 output, int xt, int yt, float ax, float ay, float bx, float by, int regWidth, int regHeight, float[] results, boolean borderRight, boolean borderBottom) {
        float Xy;
        float XY;
        int indexResults;
        if (borderRight) {
            for (int y = 0; y < regHeight; ++y) {
                int index = this.orig.startIndex + (yt + y) * this.stride + xt + regWidth;
                indexResults = output.startIndex + y * output.stride + regWidth;
                XY = this.data[index];
                Xy = this.data[index + this.stride];
                results[indexResults] = by * XY + ay * Xy;
            }
            if (borderBottom) {
                output.set(regWidth, regHeight, this.orig.get(xt + regWidth, yt + regHeight));
            } else {
                float XY2 = this.orig.get(xt + regWidth, yt + regHeight - 1);
                float Xy2 = this.orig.get(xt + regWidth, yt + regHeight);
                output.set(regWidth, regHeight - 1, by * XY2 + ay * Xy2);
            }
        }
        if (borderBottom) {
            for (int x = 0; x < regWidth; ++x) {
                int index = this.orig.startIndex + (yt + regHeight) * this.stride + xt + x;
                indexResults = output.startIndex + regHeight * output.stride + x;
                XY = this.data[index];
                Xy = this.data[index + 1];
                results[indexResults] = bx * XY + ax * Xy;
            }
            if (!borderRight) {
                float XY3 = this.orig.get(xt + regWidth - 1, yt + regHeight);
                float Xy3 = this.orig.get(xt + regWidth, regHeight);
                output.set(regWidth - 1, regHeight, by * XY3 + ay * Xy3);
            }
        }
    }
}

