/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.TriangulateTwoViewsCalibrated;
import boofcv.alg.geo.DistanceModelStereoPixels;
import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class DistanceSe3SymmetricSq
implements DistanceModelStereoPixels<Se3_F64, AssociatedPair> {
    private Se3_F64 keyToCurr;
    private TriangulateTwoViewsCalibrated triangulate;
    private Point3D_F64 p = new Point3D_F64();
    private NormalizedToPixelError errorCam1 = new NormalizedToPixelError();
    private NormalizedToPixelError errorCam2 = new NormalizedToPixelError();

    public DistanceSe3SymmetricSq(TriangulateTwoViewsCalibrated triangulate, double key_fx, double key_fy, double key_skew, double curr_fx, double curr_fy, double curr_skew) {
        this.triangulate = triangulate;
        this.setIntrinsic(key_fx, key_fy, key_skew, curr_fx, curr_fy, curr_skew);
    }

    public DistanceSe3SymmetricSq(TriangulateTwoViewsCalibrated triangulate) {
        this.triangulate = triangulate;
    }

    @Override
    public void setIntrinsic(double cam1_fx, double cam1_fy, double cam1_skew, double cam2_fx, double cam2_fy, double cam2_skew) {
        this.errorCam1.set(cam1_fx, cam1_fy, cam1_skew);
        this.errorCam2.set(cam2_fx, cam2_fy, cam2_skew);
    }

    public void setModel(Se3_F64 keyToCurr) {
        this.keyToCurr = keyToCurr;
    }

    public double computeDistance(AssociatedPair obs) {
        this.triangulate.triangulate(obs.p1, obs.p2, this.keyToCurr, this.p);
        if (this.p.z < 0.0) {
            return Double.MAX_VALUE;
        }
        double error = this.errorCam1.errorSq(obs.p1.x, obs.p1.y, this.p.x / this.p.z, this.p.y / this.p.z);
        SePointOps_F64.transform((Se3_F64)this.keyToCurr, (Point3D_F64)this.p, (Point3D_F64)this.p);
        if (this.p.z < 0.0) {
            return Double.MAX_VALUE;
        }
        return error += this.errorCam2.errorSq(obs.p2.x, obs.p2.y, this.p.x / this.p.z, this.p.y / this.p.z);
    }

    public void computeDistance(List<AssociatedPair> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            AssociatedPair obs = associatedPairs.get(i);
            distance[i] = this.computeDistance(obs);
        }
    }
}

