/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CalibrationObservation {
    public List<Point> points = new ArrayList<Point>();

    public void setTo(CalibrationObservation obs) {
        this.reset();
        for (int i = 0; i < obs.size(); ++i) {
            Point p = obs.points.get(i);
            this.points.add(new Point(p.pixel.copy(), p.index));
        }
    }

    public Point get(int index) {
        return this.points.get(index);
    }

    public void add(Point2D_F64 observation, int which) {
        this.points.add(new Point(observation, which));
    }

    public void reset() {
        this.points.clear();
    }

    public void sort() {
        Collections.sort(this.points, new Comparator<Point>(){

            @Override
            public int compare(Point o1, Point o2) {
                if (o1.index < o2.index) {
                    return -1;
                }
                if (o1.index > o2.index) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public int size() {
        return this.points.size();
    }

    public CalibrationObservation copy() {
        CalibrationObservation c = new CalibrationObservation();
        c.setTo(this);
        return c;
    }

    public static class Point {
        public Point2D_F64 pixel = new Point2D_F64();
        public int index;

        public Point(Point2D_F64 pixel, int index) {
            this.pixel.set(pixel);
            this.index = index;
        }

        public Point() {
        }
    }
}

