/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class GradientSobel_Outer {
    public static void process_I8(GrayU8 orig, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        for (int y = 1; y < height; ++y) {
            int endX = width * y + width - 1;
            for (int index = width * y + 1; index < endX; ++index) {
                int v = (data[index + width + 1] & 0xFF) - (data[index - width - 1] & 0xFF);
                int w = (data[index + width - 1] & 0xFF) - (data[index - width + 1] & 0xFF);
                imgY[index] = (short)(((data[index + width] & 0xFF) - (data[index - width] & 0xFF)) * 2 + v + w);
                imgX[index] = (short)(((data[index + 1] & 0xFF) - (data[index - 1] & 0xFF)) * 2 + v - w);
            }
        }
    }

    public static void process_I8_sub(GrayU8 orig, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int strideSrc = orig.getStride();
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            for (indexSrc = orig.startIndex + orig.stride * y + 1; indexSrc < endX; ++indexSrc) {
                int v = (data[indexSrc + strideSrc + 1] & 0xFF) - (data[indexSrc - strideSrc - 1] & 0xFF);
                int w = (data[indexSrc + strideSrc - 1] & 0xFF) - (data[indexSrc - strideSrc + 1] & 0xFF);
                imgY[indexY++] = (short)(((data[indexSrc + strideSrc] & 0xFF) - (data[indexSrc - strideSrc] & 0xFF)) * 2 + v + w);
                imgX[indexX++] = (short)(((data[indexSrc + 1] & 0xFF) - (data[indexSrc - 1] & 0xFF)) * 2 + v - w);
            }
        }
    }

    public static void process_I8_sub(GrayS16 orig, GrayS16 derivX, GrayS16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int strideSrc = orig.getStride();
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int endX = indexSrc + width - 2;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            for (indexSrc = orig.startIndex + orig.stride * y + 1; indexSrc < endX; ++indexSrc) {
                int v = data[indexSrc + strideSrc + 1] - data[indexSrc - strideSrc - 1];
                int w = data[indexSrc + strideSrc - 1] - data[indexSrc - strideSrc + 1];
                imgY[indexY++] = (short)((data[indexSrc + strideSrc] - data[indexSrc - strideSrc]) * 2 + v + w);
                imgX[indexX++] = (short)((data[indexSrc + 1] - data[indexSrc - 1]) * 2 + v - w);
            }
        }
    }

    public static void process_F32(GrayF32 orig, GrayF32 derivX, GrayF32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        for (int y = 1; y < height; ++y) {
            int endX = width * y + width - 1;
            for (int index = width * y + 1; index < endX; ++index) {
                float v = (data[index + width + 1] - data[index - width - 1]) * 0.25f;
                float w = (data[index + width - 1] - data[index - width + 1]) * 0.25f;
                imgY[index] = (data[index + width] - data[index - width]) * 0.5f + v + w;
                imgX[index] = (data[index + 1] - data[index - 1]) * 0.5f + v - w;
            }
        }
    }
}

