/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.normalized;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ConvolveNormalizedNaive {
    public static void horizontal(Kernel1D_F32 kernel, GrayF32 input, GrayF32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float total = 0.0f;
                float weight = 0.0f;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    float v = kernel.get(j - x + offset);
                    total += input.get(j, y) * v;
                    weight += v;
                }
                output.set(x, y, total / weight);
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, GrayF32 input, GrayF32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float total = 0.0f;
                float weight = 0.0f;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    float v = kernel.get(i - y + offset);
                    total += input.get(x, i) * v;
                    weight += v;
                }
                output.set(x, y, total / weight);
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, GrayF32 input, GrayF32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                float total = 0.0f;
                float weight = 0.0f;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        float v = kernel.get(j - x + offset, i - y + offset);
                        total += input.get(j, i) * v;
                        weight += v;
                    }
                }
                output.set(x, y, total / weight);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, GrayU8 input, GrayI8 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    total += input.get(j, y) * v;
                    weight += v;
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, GrayU8 input, GrayI8 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    total += input.get(x, i) * v;
                    weight += v;
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, GrayU8 input, GrayI8 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                int total = 0;
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        int v = kernel.get(j - x + offset, i - y + offset);
                        total += input.get(j, i) * v;
                        weight += v;
                    }
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, GrayS16 input, GrayI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    total += input.get(j, y) * v;
                    weight += v;
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, GrayS16 input, GrayI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    total += input.get(x, i) * v;
                    weight += v;
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, GrayS16 input, GrayI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                int total = 0;
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        int v = kernel.get(j - x + offset, i - y + offset);
                        total += input.get(j, i) * v;
                        weight += v;
                    }
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, GrayS32 input, GrayS32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    total += input.get(j, y) * v;
                    weight += v;
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, GrayS32 input, GrayS32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    total += input.get(x, i) * v;
                    weight += v;
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, GrayS32 input, GrayS32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                int total = 0;
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        int v = kernel.get(j - x + offset, i - y + offset);
                        total += input.get(j, i) * v;
                        weight += v;
                    }
                }
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernelX, Kernel1D_I32 kernelY, GrayU16 input, GrayI8 output) {
        int offsetX = kernelX.getOffset();
        int offsetY = kernelY.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weightY = 0;
                int startY = y - offsetY;
                int endY = startY + kernelY.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernelY.get(i - y + offsetY);
                    total += input.get(x, i) * v;
                    weightY += v;
                }
                int kerX0 = Math.max(0, offsetX - x);
                int kerX1 = Math.min(kernelX.getWidth(), width - x + offsetX);
                int weightX = 0;
                for (int i = kerX0; i < kerX1; ++i) {
                    weightX += kernelX.get(i);
                }
                int weight = weightX * weightY;
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernelX, Kernel1D_I32 kernelY, GrayS32 input, GrayI16 output) {
        int offsetX = kernelX.getOffset();
        int offsetY = kernelY.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int total = 0;
                int weightY = 0;
                int startY = y - offsetY;
                int endY = startY + kernelY.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernelY.get(i - y + offsetY);
                    total += input.get(x, i) * v;
                    weightY += v;
                }
                int kerX0 = Math.max(0, offsetX - x);
                int kerX1 = Math.min(kernelX.getWidth(), width - x + offsetX);
                int weightX = 0;
                for (int i = kerX0; i < kerX1; ++i) {
                    weightX += kernelX.get(i);
                }
                int weight = weightX * weightY;
                output.set(x, y, (total + weight / 2) / weight);
            }
        }
    }
}

