/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.struct.image.GrayU8;

public class ImplMedianHistogramInner {
    public static void process(GrayU8 input, GrayU8 output, int radius, int[] offset, int[] histogram) {
        if (histogram == null) {
            histogram = new int[256];
        } else if (histogram.length < 256) {
            throw new IllegalArgumentException("'histogram' must have at least 256 elements.");
        }
        int w = 2 * radius + 1;
        if (offset == null) {
            offset = new int[w * w];
        } else if (offset.length < w * w) {
            throw new IllegalArgumentException("'offset' must be at least of length " + w * w);
        }
        int threshold = w * w / 2 + 1;
        int index = 0;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                offset[index++] = i * input.stride + j;
            }
        }
        int boxWidth = radius * 2 + 1;
        for (int y = radius; y < input.height - radius; ++y) {
            int median;
            int i;
            int seed = input.startIndex + y * input.stride + radius;
            for (i = 0; i < 256; ++i) {
                histogram[i] = 0;
            }
            for (i = 0; i < offset.length; ++i) {
                int val;
                int n = val = input.data[seed + offset[i]] & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
            int count = 0;
            for (median = 0; median < 256 && (count += histogram[median]) < threshold; ++median) {
            }
            output.data[output.startIndex + y * output.stride + radius] = (byte)median;
            for (int i2 = 0; i2 < offset.length; i2 += boxWidth) {
                int val;
                int n = val = input.data[seed + offset[i2]] & 0xFF;
                histogram[n] = histogram[n] - 1;
            }
            for (int x = radius + 1; x < input.width - radius; ++x) {
                int val;
                int i3;
                seed = input.startIndex + y * input.stride + x;
                for (i3 = boxWidth - 1; i3 < offset.length; i3 += boxWidth) {
                    int n = val = input.data[seed + offset[i3]] & 0xFF;
                    histogram[n] = histogram[n] + 1;
                }
                count = 0;
                for (median = 0; median < 256 && (count += histogram[median]) < threshold; ++median) {
                }
                output.data[output.startIndex + y * output.stride + x] = (byte)median;
                for (i3 = 0; i3 < offset.length; i3 += boxWidth) {
                    int n = val = input.data[seed + offset[i3]] & 0xFF;
                    histogram[n] = histogram[n] - 1;
                }
            }
        }
    }
}

