/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;

public abstract class ThresholdSquareBlockMinMax<T extends ImageGray, I extends ImageInterleaved> {
    protected I minmax;
    protected double minimumSpread;
    protected int requestedBlockWidth;
    protected int blockWidth;
    protected int blockHeight;

    public ThresholdSquareBlockMinMax(double minimumSpread, int requestedBlockWidth) {
        this.minimumSpread = minimumSpread;
        this.requestedBlockWidth = requestedBlockWidth;
    }

    public void process(T input, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        if (((ImageGray)input).width < this.requestedBlockWidth || ((ImageGray)input).height < this.requestedBlockWidth) {
            throw new IllegalArgumentException("Image is smaller than block size");
        }
        this.selectBlockSize(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageInterleaved)this.minmax).reshape(((ImageGray)input).width / this.blockWidth, ((ImageGray)input).height / this.blockHeight);
        int innerWidth = ((ImageGray)input).width % this.blockWidth == 0 ? ((ImageGray)input).width : ((ImageGray)input).width - this.blockWidth - ((ImageGray)input).width % this.blockWidth;
        int innerHeight = ((ImageGray)input).height % this.blockHeight == 0 ? ((ImageGray)input).height : ((ImageGray)input).height - this.blockHeight - ((ImageGray)input).height % this.blockHeight;
        this.computeMinMax(input, innerWidth, innerHeight);
        this.applyThreshold(input, output);
    }

    void selectBlockSize(int width, int height) {
        int rows = height / this.requestedBlockWidth;
        int cols = width / this.requestedBlockWidth;
        this.blockHeight = height / rows;
        this.blockWidth = width / cols;
    }

    private void computeMinMax(T input, int innerWidth, int innerHeight) {
        int y;
        int indexMinMax = 0;
        for (y = 0; y < innerHeight; y += this.blockHeight) {
            int x = 0;
            while (x < innerWidth) {
                this.computeMinMaxBlock(x, y, this.blockWidth, this.blockHeight, indexMinMax, input);
                x += this.blockWidth;
                indexMinMax += 2;
            }
            if (innerWidth == ((ImageGray)input).width) continue;
            this.computeMinMaxBlock(innerWidth, y, ((ImageGray)input).width - innerWidth, this.blockHeight, indexMinMax, input);
            indexMinMax += 2;
        }
        if (innerHeight != ((ImageGray)input).height) {
            y = innerHeight;
            int blockHeight = ((ImageGray)input).height - innerHeight;
            int x = 0;
            while (x < innerWidth) {
                this.computeMinMaxBlock(x, y, this.blockWidth, blockHeight, indexMinMax, input);
                x += this.blockWidth;
                indexMinMax += 2;
            }
            if (innerWidth != ((ImageGray)input).width) {
                this.computeMinMaxBlock(innerWidth, y, ((ImageGray)input).width - innerWidth, blockHeight, indexMinMax, input);
            }
        }
    }

    private void applyThreshold(T input, GrayU8 output) {
        for (int blockY = 0; blockY < ((ImageInterleaved)this.minmax).height; ++blockY) {
            for (int blockX = 0; blockX < ((ImageInterleaved)this.minmax).width; ++blockX) {
                this.thresholdBlock(blockX, blockY, input, output);
            }
        }
    }

    protected abstract void thresholdBlock(int var1, int var2, T var3, GrayU8 var4);

    protected abstract void computeMinMaxBlock(int var1, int var2, int var3, int var4, int var5, T var6);
}

