/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.fiducial.calib.squares.CrossClustersIntoGrids;
import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareGridTools;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquaresIntoCrossClusters;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Polygon2D_I32;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectChessSquarePoints<T extends ImageGray> {
    BinaryPolygonDetector<T> detectorSquare;
    SquaresIntoCrossClusters s2c;
    CrossClustersIntoGrids c2g;
    private int numRows;
    private int numCols;
    private Polygon2D_I32 boundPolygon = new Polygon2D_I32();
    SquareGridTools tools = new SquareGridTools();
    FastQueue<Point2D_F64> calibrationPoints = new FastQueue(Point2D_F64.class, true);
    double maxCornerDistanceSq;
    List<List<SquareNode>> clusters;

    public DetectChessSquarePoints(int numRows, int numCols, double maxCornerDistance, BinaryPolygonDetector<T> detectorSquare) {
        this.maxCornerDistanceSq = maxCornerDistance * maxCornerDistance;
        this.numRows = numRows;
        this.numCols = numCols;
        this.detectorSquare = detectorSquare;
        this.s2c = new SquaresIntoCrossClusters(maxCornerDistance, -1);
        this.c2g = new CrossClustersIntoGrids();
    }

    public boolean process(T input, GrayU8 binary) {
        this.boundPolygon.vertexes.reset();
        this.detectorSquare.process(input, binary);
        FastQueue<Polygon2D_F64> found = this.detectorSquare.getFoundPolygons();
        FastQueue<BinaryPolygonDetector.Info> foundInfo = this.detectorSquare.getPolygonInfo();
        this.clusters = this.s2c.process(found.toList(), foundInfo.toList());
        this.c2g.process(this.clusters);
        List grids = this.c2g.getGrids().toList();
        for (int i = 0; i < grids.size(); ++i) {
            SquareGrid grid = (SquareGrid)grids.get(i);
            if (grid.rows == this.numCols && grid.columns == this.numRows) {
                this.tools.transpose(grid);
            }
            if (grid.rows != this.numRows || grid.columns != this.numCols) continue;
            if (grid.get(0, 0) == null) {
                if (grid.get(0, -1) != null) {
                    this.tools.flipColumns(grid);
                } else {
                    if (grid.get(-1, 0) == null) continue;
                    this.tools.flipRows(grid);
                }
            }
            if (!this.ensureCCW(grid)) continue;
            this.putIntoCanonical(grid);
            return this.computeCalibrationPoints(grid);
        }
        return false;
    }

    boolean ensureCCW(SquareGrid grid) {
        if (grid.columns <= 2 && grid.rows <= 2) {
            return true;
        }
        Point2D_F64 a = grid.get((int)0, (int)0).center;
        Point2D_F64 b = grid.columns > 2 ? grid.get((int)0, (int)2).center : grid.get((int)1, (int)1).center;
        Point2D_F64 c = grid.rows > 2 ? grid.get((int)2, (int)0).center : grid.get((int)1, (int)1).center;
        double x0 = b.x - a.x;
        double y1 = c.y - a.y;
        double y0 = b.y - a.y;
        double x1 = c.x - a.x;
        double z = x0 * y1 - y0 * x1;
        if (z < 0.0) {
            if (grid.columns % 2 == 1) {
                this.tools.flipColumns(grid);
            } else if (grid.rows % 2 == 1) {
                this.tools.flipRows(grid);
            } else {
                return false;
            }
        }
        return true;
    }

    void putIntoCanonical(SquareGrid grid) {
        boolean colOdd;
        boolean rowOdd = grid.rows % 2 == 1;
        boolean bl = colOdd = grid.columns % 2 == 1;
        if (colOdd == rowOdd) {
            if (rowOdd && grid.rows == grid.columns) {
                int i;
                int best = -1;
                double bestDistance = Double.MAX_VALUE;
                for (i = 0; i < 4; ++i) {
                    SquareNode n = grid.getCornerByIndex(i);
                    double d = n.center.normSq();
                    if (!(d < bestDistance)) continue;
                    best = i;
                    bestDistance = d;
                }
                for (i = 0; i < best; ++i) {
                    this.tools.rotateCCW(grid);
                }
            } else {
                double first = grid.get((int)0, (int)0).center.normSq();
                double last = grid.getCornerByIndex((int)2).center.normSq();
                if (last < first) {
                    this.tools.reverse(grid);
                }
            }
        }
    }

    boolean computeCalibrationPoints(SquareGrid grid) {
        this.calibrationPoints.reset();
        for (int row = 0; row < grid.rows - 1; ++row) {
            int offset;
            for (int col = offset = row % 2; col < grid.columns; col += 2) {
                SquareNode b;
                SquareNode a = grid.get(row, col);
                if (col > 0 && !this.setIntersection(a, b = grid.get(row + 1, col - 1), (Point2D_F64)this.calibrationPoints.grow())) {
                    return false;
                }
                if (col >= grid.columns - 1 || this.setIntersection(a, b = grid.get(row + 1, col + 1), (Point2D_F64)this.calibrationPoints.grow())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean setIntersection(SquareNode a, SquareNode n, Point2D_F64 point) {
        for (int i = 0; i < 4; ++i) {
            SquareEdge edge = a.edges[i];
            if (edge == null || edge.destination(a) != n) continue;
            Point2D_F64 p0 = edge.a.corners.get(edge.sideA);
            Point2D_F64 p1 = edge.b.corners.get(edge.sideB);
            point.x = (p0.x + p1.x) / 2.0;
            point.y = (p0.y + p1.y) / 2.0;
            return true;
        }
        return false;
    }

    public List<List<SquareNode>> getGraphs() {
        return this.clusters;
    }

    public SquaresIntoCrossClusters getShapeToClusters() {
        return this.s2c;
    }

    public CrossClustersIntoGrids getGrids() {
        return this.c2g;
    }

    public BinaryPolygonDetector<T> getDetectorSquare() {
        return this.detectorSquare;
    }

    public FastQueue<Point2D_F64> getCalibrationPoints() {
        return this.calibrationPoints;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }
}

