/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;

public class StereoDisparityWtoNaive<I extends ImageGray> {
    I imageLeft;
    I imageRight;
    int minDisparity;
    double[] score;
    int radiusX;
    int radiusY;
    int w;
    int h;

    public StereoDisparityWtoNaive(int minDisparity, int maxDisparity, int radiusWidth, int radiusHeight) {
        this.minDisparity = minDisparity;
        this.score = new double[maxDisparity];
        this.radiusX = radiusWidth;
        this.radiusY = radiusHeight;
    }

    public void process(I left, I right, GrayF32 imageDisparity) {
        InputSanityCheck.checkSameShape(left, right, imageDisparity);
        this.imageLeft = left;
        this.imageRight = right;
        this.w = ((ImageGray)left).width;
        this.h = ((ImageGray)left).height;
        for (int y = this.radiusY; y < this.h - this.radiusY; ++y) {
            for (int x = this.radiusX + this.minDisparity; x < this.w - this.radiusX; ++x) {
                int max = x - Math.max(this.radiusX - 1, x - this.score.length);
                this.processPixel(x, y, max);
                imageDisparity.set(x, y, (float)this.selectBest(max));
            }
        }
    }

    private void processPixel(int c_x, int c_y, int maxDisparity) {
        for (int i = this.minDisparity; i < maxDisparity; ++i) {
            this.score[i] = this.computeScore(c_x, c_x - i, c_y);
        }
    }

    protected double selectBest(int length) {
        double best = Double.MAX_VALUE;
        int index = -1;
        for (int i = this.minDisparity; i < length; ++i) {
            if (!(this.score[i] < best)) continue;
            best = this.score[i];
            index = i;
        }
        return index - this.minDisparity;
    }

    protected double computeScore(int leftX, int rightX, int centerY) {
        double ret = 0.0;
        for (int y = -this.radiusY; y <= this.radiusY; ++y) {
            for (int x = -this.radiusX; x <= this.radiusX; ++x) {
                double l = GeneralizedImageOps.get(this.imageLeft, leftX + x, centerY + y);
                double r = GeneralizedImageOps.get(this.imageRight, rightX + x, centerY + y);
                ret += Math.abs(l - r);
            }
        }
        return ret;
    }
}

