/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.feature.disparity.DisparitySparseScoreSadRect;
import boofcv.struct.image.GrayS16;
import java.util.Arrays;

public class ImplDisparitySparseScoreSadRect_S16
extends DisparitySparseScoreSadRect<int[], GrayS16> {
    int[] scores;

    public ImplDisparitySparseScoreSadRect_S16(int minDisparity, int maxDisparity, int radiusX, int radiusY) {
        super(minDisparity, maxDisparity, radiusX, radiusY);
        this.scores = new int[maxDisparity];
    }

    @Override
    public boolean process(int x, int y) {
        this.localMaxDisparity = Math.min(this.rangeDisparity, x - this.radiusX + 1 - this.minDisparity);
        if (this.localMaxDisparity <= 0 || x >= ((GrayS16)this.left).width - this.radiusX || y < this.radiusY || y >= ((GrayS16)this.left).height - this.radiusY) {
            return false;
        }
        Arrays.fill(this.scores, 0);
        for (int row = 0; row < this.regionHeight; ++row) {
            int startLeft = ((GrayS16)this.left).startIndex + ((GrayS16)this.left).stride * (y - this.radiusY + row) + x - this.radiusX;
            int startRight = ((GrayS16)this.right).startIndex + ((GrayS16)this.right).stride * (y - this.radiusY + row) + x - this.radiusX - this.minDisparity;
            int i = 0;
            while (i < this.localMaxDisparity) {
                int indexLeft = startLeft;
                int indexRight = startRight - i;
                int score = 0;
                for (int j = 0; j < this.regionWidth; ++j) {
                    int diff = ((GrayS16)this.left).data[indexLeft++] - ((GrayS16)this.right).data[indexRight++];
                    score += Math.abs(diff);
                }
                int n = i++;
                this.scores[n] = this.scores[n] + score;
            }
        }
        return true;
    }

    @Override
    public int[] getScore() {
        return this.scores;
    }

    @Override
    public Class<GrayS16> getImageType() {
        return GrayS16.class;
    }
}

