/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.DenoiseWavelet;
import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.struct.image.ImageGray;

public abstract class SubbandShrink<I extends ImageGray<I>>
implements DenoiseWavelet<I> {
    protected ShrinkThresholdRule<I> rule;

    protected SubbandShrink(ShrinkThresholdRule<I> rule) {
        this.rule = rule;
    }

    protected abstract Number computeThreshold(I var1);

    protected void performShrinkage(I transform, int numLevels) {
        for (int i = 0; i < numLevels; ++i) {
            int w = ((ImageGray)transform).width;
            int h = ((ImageGray)transform).height;
            int ww = w / 2;
            int hh = h / 2;
            Object subband = ((ImageGray)transform).subimage(ww, 0, w, hh, null);
            Number threshold = this.computeThreshold(subband);
            this.rule.process(subband, threshold);
            subband = ((ImageGray)transform).subimage(0, hh, ww, h, null);
            threshold = this.computeThreshold(subband);
            this.rule.process(subband, threshold);
            subband = ((ImageGray)transform).subimage(ww, hh, w, h, null);
            threshold = this.computeThreshold(subband);
            this.rule.process(subband, threshold);
            transform = ((ImageGray)transform).subimage(0, 0, ww, hh, null);
        }
    }
}

