/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.alg.denoise.ShrinkThresholdRule;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayF32;

public class ShrinkThresholdSoft_F32
implements ShrinkThresholdRule<GrayF32> {
    @Override
    public void process(GrayF32 image, Number threshold) {
        float f = threshold.floatValue();
        if (Float.isInfinite(f)) {
            ImageMiscOps.fill(image, 0.0f);
            return;
        }
        for (int y = 0; y < image.height; ++y) {
            int index;
            int end = index + image.width;
            for (index = image.startIndex + y * image.stride; index < end; ++index) {
                float v = image.data[index];
                if (Math.abs(v) < f) {
                    image.data[index] = 0.0f;
                    continue;
                }
                if (v >= f) {
                    int n = index;
                    image.data[n] = image.data[n] - f;
                    continue;
                }
                int n = index;
                image.data[n] = image.data[n] + f;
            }
        }
    }
}

