/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageGray;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class BackgroundStationaryBasic_SB<T extends ImageGray>
extends BackgroundStationaryBasic<T> {
    protected GrayF32 background = new GrayF32(1, 1);
    protected GImageGray inputWrapper;

    public BackgroundStationaryBasic_SB(float learnRate, float threshold, Class<T> imageType) {
        super(learnRate, threshold, ImageType.single(imageType));
        this.inputWrapper = FactoryGImageGray.create(imageType);
    }

    public GrayF32 getBackground() {
        return this.background;
    }

    @Override
    public void reset() {
        this.background.reshape(1, 1);
    }

    @Override
    public void updateBackground(T frame) {
        if (this.background.width == 1) {
            this.background.reshape(((ImageGray)frame).width, ((ImageGray)frame).height);
            GConvertImage.convert(frame, this.background);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame);
        this.inputWrapper.wrap((ImageGray)frame);
        float minusLearn = 1.0f - this.learnRate;
        int indexBG = 0;
        for (int y = 0; y < ((ImageGray)frame).height; ++y) {
            int indexInput = ((ImageGray)frame).startIndex + y * ((ImageGray)frame).stride;
            int end = indexInput + ((ImageGray)frame).width;
            while (indexInput < end) {
                float value = this.inputWrapper.getF(indexInput++);
                float bg = this.background.data[indexBG];
                this.background.data[indexBG++] = minusLearn * bg + this.learnRate * value;
            }
        }
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        if (this.background.width == 1) {
            ImageMiscOps.fill(segmented, (int)this.unknownValue);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame, segmented);
        this.inputWrapper.wrap((ImageGray)frame);
        float thresholdSq = this.threshold * this.threshold;
        int indexBG = 0;
        for (int y = 0; y < ((ImageGray)frame).height; ++y) {
            int indexInput = ((ImageGray)frame).startIndex + y * ((ImageGray)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + ((ImageGray)frame).width;
            while (indexInput < end) {
                float bg = this.background.data[indexBG];
                float pixelFrame = this.inputWrapper.getF(indexInput);
                float diff = bg - pixelFrame;
                segmented.data[indexSegmented] = diff * diff <= thresholdSq ? (byte)0 : 1;
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        }
    }
}

