/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.fiducial.FiducialStability;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.alg.fiducial.square.StabilitySquareFiducialEstimate;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Quadrilateral_F64;

public abstract class BaseSquare_FiducialDetector<T extends ImageGray, Detector extends BaseDetectFiducialSquare<T>>
implements FiducialDetector<T> {
    Detector alg;
    StabilitySquareFiducialEstimate stability;
    ImageType<T> type;

    public BaseSquare_FiducialDetector(Detector alg) {
        this.alg = alg;
        this.type = ImageType.single(((BaseDetectFiducialSquare)alg).getInputType());
    }

    @Override
    public void detect(T input) {
        ((BaseDetectFiducialSquare)this.alg).process(input);
    }

    @Override
    public void setIntrinsic(IntrinsicParameters intrinsic) {
        ((BaseDetectFiducialSquare)this.alg).configure(intrinsic, true);
        this.stability = new StabilitySquareFiducialEstimate(((BaseDetectFiducialSquare)this.alg).getPoseEstimator());
    }

    @Override
    public int totalFound() {
        return ((BaseDetectFiducialSquare)this.alg).getFound().size;
    }

    @Override
    public void getFiducialToCamera(int which, Se3_F64 fiducialToCamera) {
        fiducialToCamera.set(((FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get((int)which)).targetToSensor);
    }

    @Override
    public long getId(int which) {
        return ((FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get((int)which)).id;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    @Override
    public boolean computeStability(int which, double disturbance, FiducialStability results) {
        Quadrilateral_F64 quad = ((FoundFiducial)((BaseDetectFiducialSquare)this.alg).getFound().get((int)which)).location;
        if (!this.stability.process(disturbance, quad)) {
            return false;
        }
        results.location = this.stability.getLocationStability();
        results.orientation = this.stability.getOrientationStability();
        return true;
    }

    @Override
    public boolean isSupportedID() {
        return true;
    }

    @Override
    public boolean isSupportedPose() {
        return true;
    }

    @Override
    public boolean isSizeKnown() {
        return true;
    }

    public Detector getAlgorithm() {
        return this.alg;
    }
}

