/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.znerd.xmlenc.InvalidXMLException;
import org.znerd.xmlenc.XMLChecker;

public class XMLEncoder {
    private static final char[] DECLARATION_START = "<?xml version=\"1.0\" encoding=\"".toCharArray();
    private static final int DECLARATION_START_LENGTH = DECLARATION_START.length;
    private static final char[] DECLARATION_END = "\"?>".toCharArray();
    private static final int DECLARATION_END_LENGTH = DECLARATION_END.length;
    private static final char[] ESC_GREATER_THAN = new char[]{'&', 'g', 't', ';'};
    private static final char[] ESC_LESS_THAN = new char[]{'&', 'l', 't', ';'};
    private static final char[] ESC_AMPERSAND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] ESC_APOSTROPHE = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] ESC_QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] AMPERSAND_HASH = new char[]{'&', '#'};
    private static final char[] EQUALS_APOSTROPHE = new char[]{'=', '\''};
    private static final char[] EQUALS_QUOTE = new char[]{'=', '\"'};
    private final String _encoding;
    private final char[] _encodingCharArray;
    private final boolean _sevenBitEncoding;

    public static final XMLEncoder getEncoder(String string) throws IllegalArgumentException, UnsupportedEncodingException {
        return new XMLEncoder(string);
    }

    public XMLEncoder(String string) throws IllegalArgumentException, UnsupportedEncodingException {
        if (string == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        String string2 = string.toUpperCase();
        if (string2.equals("UTF-8") || string2.equals("UTF-16")) {
            this._sevenBitEncoding = false;
        } else if (string2.equals("US-ASCII") || string2.equals("ASCII") || string2.startsWith("ISO-8859-")) {
            this._sevenBitEncoding = true;
        } else {
            throw new UnsupportedEncodingException(string);
        }
        this._encoding = string;
        this._encodingCharArray = string.toCharArray();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void declaration(Writer writer) throws NullPointerException, IOException {
        writer.write(DECLARATION_START, 0, DECLARATION_START_LENGTH);
        writer.write(this._encodingCharArray);
        writer.write(DECLARATION_END, 0, DECLARATION_END_LENGTH);
    }

    public void text(Writer writer, String string, boolean bl) throws NullPointerException, InvalidXMLException, IOException {
        this.text(writer, string.toCharArray(), 0, string.length(), bl);
    }

    public void text(Writer writer, char[] cArray, int n, int n2, boolean bl) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        int n3 = n + n2;
        int n4 = n;
        if (this._sevenBitEncoding) {
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '\n' || c == '\r' || c == '=' || c == '\t') continue;
                if (c == '<') {
                    writer.write(cArray, n4, i - n4);
                    writer.write(ESC_LESS_THAN, 0, 4);
                    n4 = i + 1;
                    continue;
                }
                if (c == '>') {
                    writer.write(cArray, n4, i - n4);
                    writer.write(ESC_GREATER_THAN, 0, 4);
                    n4 = i + 1;
                    continue;
                }
                if (c == '&') {
                    if (!bl) continue;
                    writer.write(cArray, n4, i - n4);
                    writer.write(ESC_AMPERSAND, 0, 5);
                    n4 = i + 1;
                    continue;
                }
                if (c > '\u007f') {
                    writer.write(cArray, n4, i - n4);
                    writer.write(AMPERSAND_HASH, 0, 2);
                    writer.write(Integer.toString(c));
                    writer.write(59);
                    n4 = i + 1;
                    continue;
                }
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
        } else {
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c >= '?' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '\n' || c == '\r' || c == '=' || c == '\t') continue;
                if (c == '<') {
                    writer.write(cArray, n4, i - n4);
                    writer.write(ESC_LESS_THAN, 0, 4);
                    n4 = i + 1;
                    continue;
                }
                if (c == '>') {
                    writer.write(cArray, n4, i - n4);
                    writer.write(ESC_GREATER_THAN, 0, 4);
                    n4 = i + 1;
                    continue;
                }
                if (c == '&') {
                    if (!bl) continue;
                    writer.write(cArray, n4, i - n4);
                    writer.write(ESC_AMPERSAND, 0, 5);
                    n4 = i + 1;
                    continue;
                }
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
        }
        writer.write(cArray, n4, n3 - n4);
    }

    public void text(Writer writer, char c) throws IOException {
        if (this._sevenBitEncoding && c > '\u007f') {
            writer.write(AMPERSAND_HASH, 0, 2);
            writer.write(Integer.toString(c));
            writer.write(59);
        } else {
            writer.write(c);
        }
    }

    public void whitespace(Writer writer, String string) throws NullPointerException, InvalidXMLException, IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        this.whitespace(writer, cArray, 0, n);
    }

    public void whitespace(Writer writer, char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        XMLChecker.checkS(cArray, n, n2);
        writer.write(cArray, n, n2);
    }

    public void attribute(Writer writer, String string, String string2, char c, boolean bl) throws NullPointerException, IOException {
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = n2 + n;
        int n4 = 0;
        if (c == '\"') {
            writer.write(32);
            writer.write(string);
            writer.write(EQUALS_QUOTE, 0, 2);
            if (this._sevenBitEncoding) {
                for (int i = n2; i < n3; ++i) {
                    char c2 = cArray[i];
                    if (c2 >= '?' && c2 <= '\u007f' || c2 >= '\'' && c2 <= ';' || c2 >= ' ' && c2 <= '%' && c2 != '\"' || c2 == '\n' || c2 == '\r' || c2 == '=' || c2 == '\t') continue;
                    if (c2 == '<') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_LESS_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c2 == '>') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_GREATER_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c2 == '\"') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_QUOTE, 0, 6);
                        n4 = i + 1;
                        continue;
                    }
                    if (c2 == '&') {
                        if (!bl) continue;
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_AMPERSAND, 0, 5);
                        n4 = i + 1;
                        continue;
                    }
                    if (c2 > '\u007f') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(AMPERSAND_HASH, 0, 2);
                        writer.write(Integer.toString(c2));
                        writer.write(59);
                        n4 = i + 1;
                        continue;
                    }
                    throw new InvalidXMLException("The character 0x" + Integer.toHexString(c2) + " is not valid.");
                }
            } else {
                for (int i = n2; i < n3; ++i) {
                    char c3 = cArray[i];
                    if (c3 >= '?' || c3 >= '(' && c3 <= ';' || c3 >= ' ' && c3 <= '%' || c3 == '\n' || c3 == '\r' || c3 == '=' || c3 == '\t') continue;
                    if (c3 == '<') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_LESS_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c3 == '>') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_GREATER_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c3 == '\'') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_APOSTROPHE, 0, 6);
                        n4 = i + 1;
                        continue;
                    }
                    if (c3 == '&') {
                        if (!bl) continue;
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_AMPERSAND, 0, 5);
                        n4 = i + 1;
                        continue;
                    }
                    throw new InvalidXMLException("The character 0x" + Integer.toHexString(c3) + " is not valid.");
                }
            }
            writer.write(cArray, n4, n - n4);
            writer.write(c);
        } else if (c == '\'') {
            writer.write(32);
            writer.write(string);
            writer.write(EQUALS_APOSTROPHE, 0, 2);
            if (this._sevenBitEncoding) {
                for (int i = n2; i < n3; ++i) {
                    char c4 = cArray[i];
                    if (c4 >= '?' && c4 <= '\u007f' || c4 >= '(' && c4 <= ';' || c4 >= ' ' && c4 <= '%' || c4 == '\n' || c4 == '\r' || c4 == '=' || c4 == '\t') continue;
                    if (c4 == '<') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_LESS_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c4 == '>') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_GREATER_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c4 == '\'') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_APOSTROPHE, 0, 6);
                        n4 = i + 1;
                        continue;
                    }
                    if (c4 == '&') {
                        if (!bl) continue;
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_AMPERSAND, 0, 5);
                        n4 = i + 1;
                        continue;
                    }
                    if (c4 > '\u007f') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(AMPERSAND_HASH, 0, 2);
                        writer.write(Integer.toString(c4));
                        writer.write(59);
                        n4 = i + 1;
                        continue;
                    }
                    throw new InvalidXMLException("The character 0x" + Integer.toHexString(c4) + " is not valid.");
                }
            } else {
                for (int i = n2; i < n3; ++i) {
                    char c5 = cArray[i];
                    if (c5 >= '?' || c5 >= '(' && c5 <= ';' || c5 >= ' ' && c5 <= '%' || c5 == '\n' || c5 == '\r' || c5 == '=' || c5 == '\t') continue;
                    if (c5 == '<') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_LESS_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c5 == '>') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_GREATER_THAN, 0, 4);
                        n4 = i + 1;
                        continue;
                    }
                    if (c5 == '\'') {
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_APOSTROPHE, 0, 6);
                        n4 = i + 1;
                        continue;
                    }
                    if (c5 == '&') {
                        if (!bl) continue;
                        writer.write(cArray, n4, i - n4);
                        writer.write(ESC_AMPERSAND, 0, 5);
                        n4 = i + 1;
                        continue;
                    }
                    throw new InvalidXMLException("The character 0x" + Integer.toHexString(c5) + " is not valid.");
                }
            }
            writer.write(cArray, n4, n - n4);
            writer.write(c);
        } else {
            String string3 = "Character 0x" + Integer.toHexString(c) + " ('" + c + "') is not a valid quotation mark.";
            throw new IllegalArgumentException(string3);
        }
    }
}

