/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.oneloopdiv;

import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.parser.ParseTokenSimpleTensor;
import cc.redberry.core.parser.preprocessor.IndicesInsertion;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.transformations.EliminateMetricsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.Transformer;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.Indicator;
import cc.redberry.physics.oneloopdiv.Averaging;
import cc.redberry.physics.oneloopdiv.NaiveSubstitution;
import cc.redberry.physics.oneloopdiv.OneLoopInput;
import cc.redberry.physics.oneloopdiv.SqrSubs;

public final class OneLoopCounterterms {
    private static final String Flat_ = "Flat=(1/4)*HATS*HATS*HATS*HATS-HATW*HATS*HATS+(1/2)*HATW*HATW+HATS*HATN-HATM+(L-2)*NABLAS_l*HATW^l-L*NABLAS_l*HATW*HATK^l+(1/3)*((L-1)*NABLAS_l^l*HATS*HATS-L*NABLAS_l*HATK^l*HATS*HATS-(L-1)*NABLAS_l*HATS*HATS^l+L*NABLAS_l*HATS*HATS*HATK^l)-(1/2)*NABLAS_l*NABLAS_m*DELTA^{lm}-(1/4)*(L-1)*(L-2)*NABLAS_l*NABLAS_m^{lm}+(1/2)*L*(L-1)*(1/2)*(NABLAS_l*NABLAS_{m }^{m}+NABLAS_{m }*NABLAS_{l }^{m})*HATK^l";
    private static final String WR_ = "WR=-(1/2)*Power[L,2]*HATW*HATF_{lm}*Kn^l*HATK^m+(1/3)*L*HATW*HATK^a*DELTA^{lm}*n_q*R^q_{lam}+(1/3)*Power[L,2]*(L-1)*HATW*HATK^{lm}*HATK^a*n_q*R^q_{lam}-(1/6)*(L-2)*(L-3)*HATW^{lm}*R_{lm}";
    private static final String SR_ = "SR=-(1/6)*Power[L,2]*(L-1)*HATS*NABLAF_{lam}*Kn^{lm}*HATK^a+(2/3)*L*HATS*NABLAF_{lma}*Kn^a*DELTA^{lm}-(1/12)*(L-1)*(L-2)*(L-3)*HATS^{alm}*NABLAR_{alm}-(1/12)*Power[L,2]*(L-1)*(L-2)*HATS*HATK^{lma}*HATK^b*n_q*NABLAR_a^q_{lbm}+L*(L-1)*HATS*HATK^{lm}*DELTA^{ab}*n_q*((5/12)*NABLAR_a^q_{mbl}-(1/12)*NABLAR_{l}^q_{amb})-(1/2)*L*HATS*HATK^b*DELTA^{lma}*n_q*NABLAR_{a}^{q}_{lbm}";
    private static final String SSR_ = "SSR=-(1/2)*L*(L-1)*HATS*HATS^l*HATF_{lm}*HATK^{m}+(1/2)*Power[L,2]*HATS*HATS*HATF_{lm}*Kn^{l}*HATK^m+(1/12)*(L-1)*(L-2)*HATS*HATS^{lm}*R_{lm}+(1/3)*L*(L-1)*HATS*HATS^l*HATK^m*R_{lm}+(1/6)*HATS*HATS*DELTA^{lm}*R_{lm}-(1/6)*L*(L-1)*(L-2)*HATS*HATS^{lm}*HATK^a*n_q*R^q_{lam}+(1/3)*(L-1)*HATS*HATS^a*DELTA^{lm}*n_q*R^q_{lam}-(1/3)*Power[L,2]*(L-1)*HATS*HATS*HATK^{lm}*HATK^a*n_q*R^q_{lam}-(1/3)*L*HATS*HATS*HATK^a*DELTA^{lm}*n_q*R^q_{lam}";
    private static final String FF_ = "FF=-(1/24)*L*L*(L-1)*(L-1)*HATK^{lm}*F_{la}*HATK^{ab}*F_{mb}+(1/24)*L*L*HATK^l*F_{bm}*DELTA^{ab}*HATK^m*F_{al}-(5/24)*L*L*HATK^l*F_{bl}*DELTA^{ab}*HATK^m*F_{am}-(1/48)*L*L*(L-1)*HATK^l*F_{bm}*DELTA^m*HATK^{ab}*F_{al}-(1/48)*L*L*(L-1)*HATK^l*F_{bl}*DELTA^m*HATK^{ab}*F_{am}";
    private static final String FR_ = "FR=(1/40)*Power[L,2]*(L-1)*(L-2)*DELTA^l*HATK^m*HATK^{abc}*F_{la}*n_q*R^q_{cbm}-Power[L,2]*(L-1)*(L-2)*DELTA^m*HATK^{abc}*HATK^l*n_q*((1/60)*R^q_{bcl}*F_{am}+(1/12)*R^q_{bcm}*F_{al})+Power[L,2]*Power[(L-1),2]*DELTA^a*HATK^{bc}*HATK^{lm}*n_q*((1/60)*R^q_{blc}*F_{am}+(1/20)*R^q_{alc}*F_{mb}+(1/15)*R^q_{cla}*F_{mb}+(1/60)*R^q_{lmc}*F_{ab})+Power[L,2]*(L-1)*DELTA^{ab}*HATK^{cd}*HATK^{l}*n_q*((4/15)*R^q_{dbc}*F_{al}-(1/30)*R^q_{bda}*F_{cl}-(1/15)*R^q_{acl}*F_{bd}-(1/30)*R^q_{cal}*F_{bd})+Power[L,2]*(L-1)*DELTA^{ab}*HATK^c*HATK^{lm}*n_q*((7/60)*R^q_{abl}*F_{cm}-(11/60)*R^q_{blc}*F_{am}+(1/5)*R^q_{lac}*F_{bm}+(1/60)*R^q_{lam}*F_{cb})+Power[L,2]*DELTA^{lab}*HATK^c*HATK^m*n_q*((7/20)*R^q_{acb}*F_{ml}+(1/10)*R^q_{abm}*F_{cl})";
    private static final String RR_ = "RR=(1/10)*Power[L,2]*HATK^d*DELTA^{lmab}*HATK^c*n_q*n_p*R^q_{abc}*R^p_{lmd}+Power[L,2]*Power[(L-1),2]*(L-2)*HATK^{bcd}*DELTA^a*HATK^{lm}*n_q*n_p*((2/45)*R^p_{adm}*R^q_{blc}-(1/120)*R^p_{dam}*R^q_{blc})+Power[L,2]*(L-1)*HATK^d*DELTA^{abc}*HATK^{lm}*n_q*n_p*((-1/10)*R^p_{lcm}*R^q_{adb}+(1/15)*R^p_{dam}*R^q_{blc}+(1/60)*R^p_{bdm}*R^q_{cla})+Power[L,2]*Power[(L-1),2]*HATK^{cd}*DELTA^{ab}*HATK^{lm}*n_q*n_p*(-(1/20)*R^p_{lbm}*R^q_{dac}+(1/180)*R^p_{amb}*R^q_{cdl}-(7/360)*R^p_{lcm}*R^q_{adb}-(1/240)*R^p_{dbm}*R^q_{cal}-(1/120)*R^p_{bcm}*R^q_{adl}-(1/30)*R^p_{dbm}*R^q_{acl})+Power[L,2]*(L-1)*(L-2)*HATK^d*DELTA^{lm}*HATK^{abc}*n_q*n_p*((-1/30)*R^p_{cmb}*R^q_{adl}-(1/180)*R^p_{lcm}*R^q_{abd}+(1/180)*R^p_{lcd}*R^q_{abm})+Power[L,2]*Power[(L-1),2]*(L-2)*HATK^{lm}*DELTA^{d}*HATK^{abc}*n_q*n_p*((1/45)*R^p_{lcm}*R^q_{abd}-(1/80)*R^p_{bmc}*R^q_{lad}+(1/90)*R^p_{bmc}*R^q_{dal})+Power[L,2]*(L-1)*HATK^{lm}*DELTA^{abc}*HATK^d*n_q*n_p*((7/120)*R^p_{bcm}*R^q_{lad}-(3/40)*R^p_{bcd}*R^q_{lam}+(1/120)*R^p_{dcm}*R^q_{abl})+Power[L,2]*(L-1)*(L-2)*HATK^{abc}*DELTA^{lm}*HATK^d*n_q*n_p*(-(1/24)*R^p_{lcm}*R^q_{abd}-(1/180)*R^p_{mcd}*R^q_{abl}-(1/360)*R^p_{dcm}*R^q_{abl})-(1/120)*Power[L,2]*(L-1)*(L-2)*(L-3)*HATK^{lmab}*DELTA^{d}*HATK^c*n_q*n_p*R^p_{abc}*R^q_{lmd}-(1/80)*Power[L,2]*Power[(L-1),2]*(L-2)*(L-3)*HATK^{abcd}*HATK^{lm}*n_q*n_p*R^p_{bcl}*R^q_{adm}+Power[L,2]*HATK^l*DELTA^{abc}*HATK^m*n_p*(-(1/8)*R_{bc}*R^p_{mal}+(3/20)*R_{bc}*R^p_{lam}+(3/40)*R_{al}*R^p_{bcm}+(1/40)*R^q_{bcl}*R^p_{maq}-(3/20)*R^q_{abl}*R^p_{cmq}+(1/10)*R^q_{abm}*R^p_{clq})+Power[L,2]*(L-1)*HATK^c*DELTA^{ab}*HATK^{lm}*n_p*((1/20)*R_{am}*R^p_{cbl}+(1/20)*R_{ac}*R^p_{lbm}+(1/10)*R_{ab}*R^p_{lcm}+(1/20)*R^q_{amc}*R^p_{qbl}-(1/60)*R^q_{lam}*R^p_{bqc}+(1/10)*R^q_{abc}*R^p_{lqm}-(1/12)*R^q_{abm}*R^p_{lqc})+Power[L,2]*Power[(L-1),2]*HATK^{ab}*DELTA^{c}*HATK^{lm}*n_p*((1/60)*R_{al}*R^p_{bmc}-(1/20)*R_{al}*R^p_{cmb}+(1/120)*R_{ab}*R^p_{lmc}+(3/40)*R_{ac}*R^p_{mbl}+(1/20)*R^q_{cla}*R^p_{mqb}+(1/120)*R^q_{alc}*R^p_{bmq}-(1/40)*R^q_{alc}*R^p_{qmb}+(1/40)*R^q_{alb}*R^p_{qmc}-(1/20)*R^q_{alb}*R^p_{cmq}-(1/40)*R^q_{lbm}*R^p_{cqa})+Power[L,2]*(L-1)*HATK^{ab}*DELTA^{lm}*HATK^{c}*n_p*((1/20)*R^q_{lmb}*R^p_{cqa}-(7/60)*R^q_{bla}*R^p_{cmq}+(1/20)*R^q_{bla}*R^p_{qmc}+(1/10)*R^q_{lbc}*R^p_{maq}+(1/60)*R^q_{blc}*R^p_{amq}+(7/120)*R_{ab}*R^p_{mcl}+(11/60)*R_{bl}*R^p_{mac})+Power[L,2]*(L-1)*(L-2)*HATK^{abc}*DELTA^{l}*HATK^{m}*n_p*((7/240)*R_{ab}*R^p_{clm}+(7/240)*R_{am}*R^p_{bcl}-(1/60)*R_{al}*R^p_{bcm}-(1/24)*R^q_{abm}*R^p_{qcl}+(1/15)*R^q_{abm}*R^p_{lcq}+(1/40)*R^q_{abl}*R^p_{qcm}+(1/40)*R_{bc}*R^p_{mla}+(1/48)*R^q_{bcl}*R^p_{maq})+Power[L,2]*Power[(L-1),2]*(L-2)*HATK^{abc}*HATK^{lm}*n_p*((-7/240)*R_{al}*R^p_{bcm}+(1/240)*R_{bc}*R^p_{lam}-(1/40)*R^q_{alb}*R^p_{mcq})+L*(L-1)*(L-2)*(L-3)*HATK^{lmab}*((1/180)*R_{lm}*R_{ab}+(7/720)*R^q_{abp}*R^p_{lmq})";
    private static final String DELTA_1_ = "DELTA^l=-L*HATK^l";
    private static final String DELTA_2_ = "DELTA^{lm}=-(1/2)*L*(L-1)*HATK^{lm}+Power[L,2]*(1/2)*(HATK^{l }*HATK^{m }+HATK^{m }*HATK^{l })";
    private static final String DELTA_3_ = "DELTA^{lma}=-(1/6)*L*(L-1)*(L-2)*HATK^{lma}+(1/2)*Power[L,2]*(L-1)*(1/3)*(HATK^{l m }*HATK^{a }+HATK^{a m }*HATK^{l }+HATK^{l a }*HATK^{m })+1/2*Power[L,2]*(L-1)*(1/3)*(HATK^{a }*HATK^{l m }+HATK^{l }*HATK^{a m }+HATK^{m }*HATK^{a l })-Power[L,3]*(1/6)*(HATK^{l }*HATK^{m }*HATK^{a }+HATK^{l }*HATK^{a }*HATK^{m }+HATK^{m }*HATK^{a }*HATK^{l }+HATK^{m }*HATK^{l }*HATK^{a }+HATK^{a }*HATK^{l }*HATK^{m }+HATK^{a }*HATK^{m }*HATK^{l })";
    private static final String DELTA_4_ = "DELTA^{lmab}=-(1/24)*L*(L-1)*(L-2)*(L-3)*HATK^{lmab}+(1/6)*Power[L,2]*(L-1)*(L-2)*(1/4)*(HATK^{l m a }*HATK^{b }+HATK^{l m b }*HATK^{a }+HATK^{b l a }*HATK^{m }+HATK^{m b a }*HATK^{l })+(1/6)*Power[L,2]*(L-1)*(L-2)*(1/4)*(HATK^{b }*HATK^{l m a }+HATK^{a }*HATK^{l m b }+HATK^{l }*HATK^{b m a }+HATK^{m }*HATK^{b l a })+(1/4)*Power[L,2]*Power[(L-1),2]*(1/6)*(HATK^{lm}*HATK^{ab}+HATK^{lb}*HATK^{am}+HATK^{la}*HATK^{mb}+HATK^{am}*HATK^{lb}+HATK^{bm}*HATK^{al}+HATK^{ab}*HATK^{lm})-(1/2)*Power[L,3]*(L-1)*(1/12)*(HATK^{lm}*HATK^a*HATK^b+HATK^{lm}*HATK^b*HATK^a+HATK^{lb}*HATK^a*HATK^m+HATK^{lb}*HATK^m*HATK^a+HATK^{la}*HATK^m*HATK^b+HATK^{la}*HATK^b*HATK^m+HATK^{ma}*HATK^l*HATK^b+HATK^{ma}*HATK^b*HATK^l+HATK^{mb}*HATK^a*HATK^l+HATK^{mb}*HATK^l*HATK^a+HATK^{ab}*HATK^l*HATK^m+HATK^{ab}*HATK^m*HATK^l)-(1/2)*Power[L,3]*(L-1)*(1/12)*(HATK^a*HATK^{lm}*HATK^b+HATK^b*HATK^{lm}*HATK^a+HATK^a*HATK^{lb}*HATK^m+HATK^m*HATK^{lb}*HATK^a+HATK^m*HATK^{la}*HATK^b+HATK^b*HATK^{la}*HATK^m+HATK^l*HATK^{ma}*HATK^b+HATK^b*HATK^{ma}*HATK^l+HATK^a*HATK^{mb}*HATK^l+HATK^l*HATK^{mb}*HATK^a+HATK^l*HATK^{ab}*HATK^m+HATK^m*HATK^{ab}*HATK^l)-(1/2)*Power[L,3]*(L-1)*(1/12)*(HATK^a*HATK^b*HATK^{lm}+HATK^b*HATK^a*HATK^{lm}+HATK^a*HATK^m*HATK^{lb}+HATK^m*HATK^a*HATK^{lb}+HATK^m*HATK^b*HATK^{la}+HATK^b*HATK^m*HATK^{la}+HATK^l*HATK^b*HATK^{ma}+HATK^b*HATK^l*HATK^{ma}+HATK^a*HATK^l*HATK^{mb}+HATK^l*HATK^a*HATK^{mb}+HATK^l*HATK^m*HATK^{ab}+HATK^m*HATK^l*HATK^{ab})+(1/24)*Power[L,4]*(HATK^{l}*HATK^{m}*HATK^{a}*HATK^{b}+HATK^{m}*HATK^{l}*HATK^{a}*HATK^{b}+HATK^{b}*HATK^{m}*HATK^{a}*HATK^{l}+HATK^{m}*HATK^{b}*HATK^{a}*HATK^{l}+HATK^{b}*HATK^{l}*HATK^{a}*HATK^{m}+HATK^{l}*HATK^{b}*HATK^{a}*HATK^{m}+HATK^{l}*HATK^{m}*HATK^{b}*HATK^{a}+HATK^{m}*HATK^{l}*HATK^{b}*HATK^{a}+HATK^{a}*HATK^{m}*HATK^{b}*HATK^{l}+HATK^{m}*HATK^{a}*HATK^{b}*HATK^{l}+HATK^{a}*HATK^{l}*HATK^{b}*HATK^{m}+HATK^{l}*HATK^{a}*HATK^{b}*HATK^{m}+HATK^{b}*HATK^{m}*HATK^{l}*HATK^{a}+HATK^{m}*HATK^{b}*HATK^{l}*HATK^{a}+HATK^{a}*HATK^{m}*HATK^{l}*HATK^{b}+HATK^{m}*HATK^{a}*HATK^{l}*HATK^{b}+HATK^{a}*HATK^{b}*HATK^{l}*HATK^{m}+HATK^{b}*HATK^{a}*HATK^{l}*HATK^{m}+HATK^{b}*HATK^{l}*HATK^{m}*HATK^{a}+HATK^{l}*HATK^{b}*HATK^{m}*HATK^{a}+HATK^{a}*HATK^{l}*HATK^{m}*HATK^{b}+HATK^{l}*HATK^{a}*HATK^{m}*HATK^{b}+HATK^{a}*HATK^{b}*HATK^{m}*HATK^{l}+HATK^{b}*HATK^{a}*HATK^{m}*HATK^{l})";
    private static final String ACTION_ = "counterterms = Flat + WR + SR + SSR + FF + FR + RR";
    private final Expression Flat;
    private final Expression WR;
    private final Expression SR;
    private final Expression SSR;
    private final Expression FF;
    private final Expression FR;
    private final Expression RR;
    private final Expression DELTA_1;
    private final Expression DELTA_2;
    private final Expression DELTA_3;
    private final Expression DELTA_4;
    private final Expression ACTION;

    private OneLoopCounterterms(Expression Flat, Expression WR, Expression SR, Expression SSR, Expression FF, Expression FR, Expression RR, Expression DELTA_1, Expression DELTA_2, Expression DELTA_3, Expression DELTA_4, Expression ACTION) {
        this.Flat = Flat;
        this.WR = WR;
        this.SR = SR;
        this.SSR = SSR;
        this.FF = FF;
        this.FR = FR;
        this.RR = RR;
        this.DELTA_1 = DELTA_1;
        this.DELTA_2 = DELTA_2;
        this.DELTA_3 = DELTA_3;
        this.DELTA_4 = DELTA_4;
        this.ACTION = ACTION;
    }

    public Expression Flat() {
        return this.Flat;
    }

    public Expression WR() {
        return this.WR;
    }

    public Expression SR() {
        return this.SR;
    }

    public Expression SSR() {
        return this.SSR;
    }

    public Expression FF() {
        return this.FF;
    }

    public Expression FR() {
        return this.FR;
    }

    public Expression RR() {
        return this.RR;
    }

    public Expression getCounterterms() {
        return this.ACTION;
    }

    public Expression DELTA_1() {
        return this.DELTA_1;
    }

    public Expression DELTA_2() {
        return this.DELTA_2;
    }

    public Expression DELTA_3() {
        return this.DELTA_3;
    }

    public Expression DELTA_4() {
        return this.DELTA_4;
    }

    public static OneLoopCounterterms calculateOneLoopCounterterms(OneLoopInput input) {
        int n;
        Tensor temp;
        int i;
        final String[] matrices = new String[]{"iK", "HATK", "HATW", "HATS", "NABLAS", "HATN", "HATF", "NABLAF", "HATM", "DELTA", "Flat", "FF", "WR", "SR", "SSR", "FR", "RR", "Kn"};
        final StructureOfIndices F_TYPE_STRUCTURE = StructureOfIndices.create(IndexType.LatinLower.getType(), 2);
        Indicator<ParseTokenSimpleTensor> matricesIndicator = new Indicator<ParseTokenSimpleTensor>(){

            @Override
            public boolean is(ParseTokenSimpleTensor object) {
                String name = object.name;
                for (String matrix : matrices) {
                    if (!name.equals(matrix)) continue;
                    return true;
                }
                return name.equals("F") && object.indices.getStructureOfIndices().equals(F_TYPE_STRUCTURE);
            }
        };
        int matrixIndicesCount = input.getMatrixIndicesCount();
        int operatorOrder = input.getOperatorOrder();
        int[] upper = new int[matrixIndicesCount / 2];
        int[] lower = (int[])upper.clone();
        for (i = 0; i < matrixIndicesCount / 2; ++i) {
            upper[i] = IndicesUtils.createIndex(130 + i, IndexType.LatinLower, true);
            lower[i] = IndicesUtils.createIndex(130 + i + matrixIndicesCount / 2, IndexType.LatinLower, false);
        }
        IndicesInsertion termIndicesInsertion = new IndicesInsertion(IndicesFactory.createSimple(null, upper), IndicesFactory.createSimple(null, IndicesUtils.getIndicesNames(upper)), matricesIndicator);
        Expression Flat = (Expression)Tensors.parse(Flat_, termIndicesInsertion);
        Expression WR = (Expression)Tensors.parse(WR_, termIndicesInsertion);
        Expression SR = (Expression)Tensors.parse(SR_, termIndicesInsertion);
        Expression SSR = (Expression)Tensors.parse(SSR_, termIndicesInsertion);
        Expression FF = (Expression)Tensors.parse(FF_, termIndicesInsertion);
        Expression FR = (Expression)Tensors.parse(FR_, termIndicesInsertion);
        Expression RR = (Expression)Tensors.parse(RR_, termIndicesInsertion);
        Expression ACTION = (Expression)Tensors.parse(ACTION_, termIndicesInsertion);
        Expression[] terms = new Expression[]{Flat, WR, SR, SSR, FF, FR, RR};
        IndicesInsertion deltaIndicesInsertion = new IndicesInsertion(IndicesFactory.createSimple(null, upper), IndicesFactory.createSimple(null, lower), matricesIndicator);
        Expression DELTA_1 = (Expression)Tensors.parse(DELTA_1_, deltaIndicesInsertion);
        Expression DELTA_2 = (Expression)Tensors.parse(DELTA_2_, deltaIndicesInsertion);
        Expression DELTA_3 = (Expression)Tensors.parse(DELTA_3_, deltaIndicesInsertion);
        Expression DELTA_4 = (Expression)Tensors.parse(DELTA_4_, deltaIndicesInsertion);
        Expression[] deltaExpressions = new Expression[]{DELTA_1, DELTA_2, DELTA_3, DELTA_4};
        Expression FSubstitution = input.getF();
        for (Transformation background : input.getRiemannBackground()) {
            FSubstitution = (Expression)background.transform(FSubstitution);
        }
        Expression[] riemansSubstitutions = new Expression[]{FSubstitution, Tensors.parseExpression("R_{l m}^{l}_{a} = R_{ma}"), Tensors.parseExpression("R_{lm}^{a}_{a}=0"), Tensors.parseExpression("F_{l}^{l}^{a}_{b}=0"), Tensors.parseExpression("R_{lmab}*R^{lamb}=(1/2)*R_{lmab}*R^{lmab}"), Tensors.parseExpression("R_{lmab}*R^{lmab}=4*R_{lm}*R^{lm}-R*R"), Tensors.parseExpression("R_{l}^{l}= R")};
        Expression kronecker = (Expression)Tensors.parse("d_{l}^{l}=4");
        SqrSubs n2 = new SqrSubs(Tensors.parseSimple("n_l"));
        Transformer n2Transformer = new Transformer(TraverseState.Leaving, new Transformation[]{n2});
        Transformation[] common = new Transformation[]{EliminateMetricsTransformation.ELIMINATE_METRICS, n2Transformer, kronecker};
        Transformation[] all = ArraysUtils.addAll(common, riemansSubstitutions);
        for (i = 0; i < 2; ++i) {
            temp = deltaExpressions[i];
            temp = input.getL().transform(temp);
            for (Expression hatK : input.getHatQuantities(0)) {
                temp = hatK.transform(temp);
            }
            temp = ExpandTransformation.expand(temp, common);
            for (Transformation tr : common) {
                temp = tr.transform(temp);
            }
            deltaExpressions[i] = temp;
        }
        Tensor[] combinations = new Tensor[]{Tensors.parse("HATK^{lma}", deltaIndicesInsertion), Tensors.parse("HATK^{lm}*HATK^{a}", deltaIndicesInsertion), Tensors.parse("HATK^{a}*HATK^{lm}", deltaIndicesInsertion), Tensors.parse("HATK^{l}*HATK^{m}*HATK^{a}", deltaIndicesInsertion)};
        Expression[] calculatedCombinations = new Expression[combinations.length];
        for (i = 0; i < combinations.length; ++i) {
            temp = combinations[i];
            for (Expression expression : input.getHatQuantities(0)) {
                temp = expression.transform(temp);
            }
            temp = ExpandTransformation.expand(temp, common);
            Transformation[] transformationArray = common;
            int n3 = transformationArray.length;
            for (n = 0; n < n3; ++n) {
                Transformation transformation = transformationArray[n];
                temp = transformation.transform(temp);
            }
            calculatedCombinations[i] = Tensors.expression(combinations[i], temp);
        }
        temp = DELTA_3;
        temp = input.getL().transform(temp);
        for (Expression expression : calculatedCombinations) {
            temp = new NaiveSubstitution(expression.get(0), expression.get(1)).transform(temp);
        }
        temp = ExpandTransformation.expand(temp, common);
        for (Transformation transformation : common) {
            temp = transformation.transform(temp);
        }
        deltaExpressions[2] = temp;
        combinations = new Tensor[]{Tensors.parse("HATK^{lmab}", deltaIndicesInsertion), Tensors.parse("HATK^{lma}*HATK^{b}", deltaIndicesInsertion), Tensors.parse("HATK^{b}*HATK^{lma }", deltaIndicesInsertion), Tensors.parse("HATK^{ab}*HATK^{lm}", deltaIndicesInsertion), Tensors.parse("HATK^{l}*HATK^{m}*HATK^{ab}", deltaIndicesInsertion), Tensors.parse("HATK^{l}*HATK^{ab}*HATK^{m}", deltaIndicesInsertion), Tensors.parse("HATK^{ab}*HATK^{l}*HATK^{m}", deltaIndicesInsertion), Tensors.parse("HATK^{b}*HATK^{a}*HATK^{l}*HATK^{m}", deltaIndicesInsertion)};
        calculatedCombinations = new Expression[combinations.length];
        for (i = 0; i < combinations.length; ++i) {
            temp = combinations[i];
            for (Transformation transformation : input.getHatQuantities(0)) {
                temp = ((Expression)transformation).transform(temp);
            }
            temp = ExpandTransformation.expand(temp, common);
            for (Transformation transformation : common) {
                temp = transformation.transform(temp);
            }
            calculatedCombinations[i] = Tensors.expression(combinations[i], temp);
        }
        temp = DELTA_4;
        temp = input.getL().transform(temp);
        for (Transformation transformation : calculatedCombinations) {
            temp = new NaiveSubstitution(((Expression)transformation).get(0), ((Expression)transformation).get(1)).transform(temp);
        }
        temp = ExpandTransformation.expand(temp, common);
        for (Transformation transformation : common) {
            temp = transformation.transform(temp);
        }
        deltaExpressions[3] = temp;
        for (i = 0; i < terms.length; ++i) {
            temp = terms[i];
            temp = input.getL().transform(temp);
            temp = input.getF().transform(temp);
            temp = input.getHatF().transform(temp);
            for (Transformation transformation : input.getRiemannBackground()) {
                temp = transformation.transform(temp);
            }
            for (Transformation transformation : all) {
                temp = transformation.transform(temp);
            }
            for (Transformation transformation : input.getNablaS()) {
                temp = ((Expression)transformation).transform(temp);
            }
            temp = input.getF().transform(temp);
            temp = input.getHatF().transform(temp);
            for (Transformation transformation : input.getKnQuantities()) {
                temp = ((Expression)transformation).transform(temp);
            }
            Transformation[] transformationArray = input.getHatQuantities();
            int n4 = transformationArray.length;
            for (n = 0; n < n4; ++n) {
                Transformation transformation;
                for (Transformation hatQ : transformation = transformationArray[n]) {
                    temp = ((Expression)hatQ).transform(temp);
                }
            }
            for (Transformation transformation : deltaExpressions) {
                temp = ((Expression)transformation).transform(temp);
            }
            temp = ExpandTransformation.expand(temp, all);
            for (Transformation transformation : all) {
                temp = transformation.transform(temp);
            }
            temp = new Averaging(Tensors.parseSimple("n_l")).transform(temp);
            temp = ExpandTransformation.expand(temp, all);
            for (Transformation transformation : all) {
                temp = transformation.transform(temp);
            }
            terms[i] = temp = ExpandTransformation.expand(temp, all);
        }
        for (Transformation transformation : terms) {
            ACTION = (Expression)((Expression)transformation).transform(ACTION);
        }
        return new OneLoopCounterterms(Flat, WR, SR, SSR, FF, FR, RR, deltaExpressions[0], deltaExpressions[1], deltaExpressions[2], deltaExpressions[3], ACTION);
    }
}

