/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.context.CC;
import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indexmapping.IndexMappings;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indexmapping.MappingsPort;
import cc.redberry.core.indices.InconsistentIndicesException;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.MultiTensor;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArray;
import cc.redberry.core.utils.OutputPort;
import cc.redberry.core.utils.THashSet;
import gnu.trove.TIntCollection;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TensorUtils {
    private TensorUtils() {
    }

    public static boolean haveIndicesIntersections(Tensor u, Tensor v) {
        return IndicesUtils.haveIntersections(u.getIndices(), v.getIndices());
    }

    public static boolean isZeroOrIndeterminate(Tensor tensor) {
        return tensor instanceof Complex && NumberUtils.isZeroOrIndeterminate((Complex)tensor);
    }

    public static boolean isIndeterminate(Tensor tensor) {
        return tensor instanceof Complex && NumberUtils.isIndeterminate((Complex)tensor);
    }

    public static boolean isInteger(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isInteger();
    }

    public static boolean isNaturalNumber(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isNatural();
    }

    public static boolean isNumeric(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isNumeric();
    }

    public static boolean isNegativeNaturalNumber(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isNegativeNatural();
    }

    public static boolean isPositiveNaturalNumber(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isPositiveNatural();
    }

    public static boolean isRealPositiveNumber(Tensor tensor) {
        if (tensor instanceof Complex) {
            Complex complex = (Complex)tensor;
            return complex.isReal() && complex.getReal().signum() > 0;
        }
        return false;
    }

    public static boolean isRealNegativeNumber(Tensor tensor) {
        if (tensor instanceof Complex) {
            Complex complex = (Complex)tensor;
            return complex.isReal() && complex.getReal().signum() < 0;
        }
        return false;
    }

    public static boolean isIndexless(Tensor ... tensors) {
        for (Tensor t : tensors) {
            if (TensorUtils.isIndexless1(t)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIndexless1(Tensor tensor) {
        return tensor.getIndices().size() == 0;
    }

    public static boolean isScalar(Tensor ... tensors) {
        for (Tensor t : tensors) {
            if (TensorUtils.isScalar1(t)) continue;
            return false;
        }
        return true;
    }

    private static boolean isScalar1(Tensor tensor) {
        return tensor.getIndices().getFree().size() == 0;
    }

    public static boolean isSymbol(Tensor t) {
        return t.getClass() == SimpleTensor.class && t.getIndices().size() == 0;
    }

    public static boolean isSymbolOrNumber(Tensor t) {
        return t instanceof Complex || TensorUtils.isSymbol(t);
    }

    public static boolean isSymbolic(Tensor t) {
        if (t.getClass() == SimpleTensor.class) {
            return t.getIndices().size() == 0;
        }
        if (t instanceof TensorField) {
            boolean b;
            boolean bl = b = t.getIndices().size() == 0;
            if (!b) {
                return false;
            }
        }
        if (t instanceof Complex) {
            return true;
        }
        for (Tensor c : t) {
            if (TensorUtils.isSymbolic(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSymbolic(Tensor ... tensors) {
        for (Tensor t : tensors) {
            if (TensorUtils.isSymbolic(t)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOne(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isOne();
    }

    public static boolean isZero(Tensor tensor) {
        return tensor instanceof Complex && ((Complex)tensor).isZero();
    }

    public static boolean isImageOne(Tensor tensor) {
        return tensor instanceof Complex && tensor.equals(Complex.IMAGINARY_UNIT);
    }

    public static boolean isMinusOne(Tensor tensor) {
        return tensor instanceof Complex && tensor.equals(Complex.MINUS_ONE);
    }

    public static boolean isIntegerOdd(Tensor tensor) {
        return tensor instanceof Complex && NumberUtils.isIntegerOdd((Complex)tensor);
    }

    public static boolean isIntegerEven(Tensor tensor) {
        return tensor instanceof Complex && NumberUtils.isIntegerEven((Complex)tensor);
    }

    public static boolean isPositiveIntegerPower(Tensor t) {
        return t instanceof Power && TensorUtils.isPositiveNaturalNumber(t.get(1));
    }

    public static boolean isPositiveIntegerPowerOfSimpleTensor(Tensor t) {
        return TensorUtils.isPositiveIntegerPower(t) && t.get(0) instanceof SimpleTensor;
    }

    public static boolean isPositiveIntegerPowerOfProduct(Tensor t) {
        return TensorUtils.isPositiveIntegerPower(t) && t.get(0) instanceof Product;
    }

    public static boolean isNegativeIntegerPower(Tensor t) {
        return t instanceof Power && TensorUtils.isNegativeNaturalNumber(t.get(1));
    }

    public static boolean passOutDummies(Tensor tensor) {
        return TensorUtils.getAllDummyIndicesT(tensor).size() != 0;
    }

    public static boolean containsSimpleTensors(Tensor tensor, TIntSet setOfNames) {
        Tensor current;
        FromChildToParentIterator iterator = new FromChildToParentIterator(tensor);
        boolean contains = false;
        while ((current = iterator.next()) != null) {
            if (!(current instanceof SimpleTensor) || !setOfNames.contains(((SimpleTensor)current).getName())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static boolean equalsExactly(Tensor[] u, Tensor[] v) {
        if (u.length != v.length) {
            return false;
        }
        for (int i = 0; i < u.length; ++i) {
            if (TensorUtils.equalsExactly(u[i], v[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsExactly(Tensor u, String v) {
        return TensorUtils.equalsExactly(u, Tensors.parse(v));
    }

    public static boolean equalsExactly(Tensor u, Tensor v) {
        int size;
        if (u == v) {
            return true;
        }
        if (u.getClass() != v.getClass()) {
            return false;
        }
        if (u instanceof Complex) {
            return u.equals(v);
        }
        if (u.hashCode() != v.hashCode()) {
            return false;
        }
        if (u.getClass() == SimpleTensor.class) {
            return u.getIndices().equals(v.getIndices());
        }
        if (u.size() != v.size()) {
            return false;
        }
        if (u instanceof MultiTensor) {
            int i;
            size = u.size();
            int[] hashArray = new int[size];
            for (i = 0; i < size; ++i) {
                hashArray[i] = u.get(i).hashCode();
                if (hashArray[i] == v.get(i).hashCode()) continue;
                return false;
            }
            int begin = 0;
            for (i = 1; i <= size; ++i) {
                if (i != size && hashArray[i] == hashArray[i - 1]) continue;
                if (i - 1 != begin) {
                    int stretchLength = i - begin;
                    boolean[] usedPos = new boolean[stretchLength];
                    for (int n = begin; n < i; ++n) {
                        block16: {
                            for (int j = begin; j < i; ++j) {
                                if (usedPos[j - begin] || !TensorUtils.equalsExactly(u.get(n), v.get(j))) {
                                    continue;
                                }
                                break block16;
                            }
                            return false;
                        }
                        usedPos[j - begin] = true;
                    }
                    return true;
                }
                if (!TensorUtils.equalsExactly(u.get(i - 1), v.get(i - 1))) {
                    return false;
                }
                begin = i;
            }
        }
        if (!(u.getClass() != TensorField.class || ((SimpleTensor)u).getName() == ((SimpleTensor)v).getName() && u.getIndices().equals(v.getIndices()))) {
            return false;
        }
        size = u.size();
        for (int i = 0; i < size; ++i) {
            if (TensorUtils.equalsExactly(u.get(i), v.get(i))) continue;
            return false;
        }
        return true;
    }

    public static TIntHashSet getAllDummyIndicesT(Tensor tensor) {
        return TensorUtils.getAllDummyIndicesT(false, tensor);
    }

    public static TIntHashSet getAllDummyIndicesIncludingScalarFunctionsT(Tensor tensor) {
        return TensorUtils.getAllDummyIndicesT(true, tensor);
    }

    private static TIntHashSet getAllDummyIndicesT(boolean includeScalarFunctions, Tensor tensor) {
        TIntHashSet set = new TIntHashSet();
        TensorUtils.appendAllIndicesNamesT(tensor, set, includeScalarFunctions);
        set.removeAll(IndicesUtils.getIndicesNames(tensor.getIndices().getFree()));
        return set;
    }

    public static TIntHashSet getAllIndicesNamesT(Collection<? extends Tensor> tensors) {
        TIntHashSet set = new TIntHashSet();
        for (Tensor tensor : tensors) {
            TensorUtils.appendAllIndicesNamesT(tensor, set);
        }
        return set;
    }

    public static TIntHashSet getAllIndicesNamesT(Tensor ... tensors) {
        TIntHashSet set = new TIntHashSet();
        for (Tensor tensor : tensors) {
            TensorUtils.appendAllIndicesNamesT(tensor, set, false);
        }
        return set;
    }

    public static void appendAllIndicesNamesT(Tensor tensor, TIntHashSet set) {
        TensorUtils.appendAllIndicesNamesT(tensor, set, false);
    }

    public static void appendAllIndicesNamesIncludingScalarFunctionsT(Tensor tensor, TIntHashSet set) {
        TensorUtils.appendAllIndicesNamesT(tensor, set, true);
    }

    private static void appendAllIndicesNamesT(Tensor tensor, TIntHashSet set, boolean includeScalarFunctions) {
        if (tensor instanceof SimpleTensor) {
            Indices ind = tensor.getIndices();
            set.ensureCapacity(ind.size());
            int size = ind.size();
            for (int i = 0; i < size; ++i) {
                set.add(IndicesUtils.getNameWithType(ind.get(i)));
            }
        } else if (tensor instanceof Power) {
            TensorUtils.appendAllIndicesNamesT(tensor.get(0), set);
        } else {
            if (tensor instanceof ScalarFunction && !includeScalarFunctions) {
                return;
            }
            for (int i = tensor.size() - 1; i >= 0; --i) {
                Tensor t = tensor.get(i);
                TensorUtils.appendAllIndicesNamesT(t, set);
            }
        }
    }

    public static boolean equals(Tensor u, Tensor v) {
        return IndexMappings.equals(u, v);
    }

    public static Boolean compare1(Tensor u, Tensor v) {
        return IndexMappings.compare1(u, v);
    }

    public static void assertIndicesConsistency(Tensor t) {
        TensorUtils.assertIndicesConsistency(t, new TIntHashSet());
    }

    private static void assertIndicesConsistency(Tensor t, TIntHashSet indices) {
        if (t instanceof SimpleTensor) {
            Indices ind = t.getIndices();
            for (int i = ind.size() - 1; i >= 0; --i) {
                if (indices.contains(ind.get(i))) {
                    throw new AssertionError((Object)new InconsistentIndicesException(ind.get(i)));
                }
                indices.add(ind.get(i));
            }
        }
        if (t instanceof Product) {
            for (int i = t.size() - 1; i >= 0; --i) {
                TensorUtils.assertIndicesConsistency(t.get(i), indices);
            }
        }
        if (t instanceof Sum) {
            TIntHashSet sumIndices = new TIntHashSet();
            for (int i = t.size() - 1; i >= 0; --i) {
                TIntHashSet temp = new TIntHashSet((TIntCollection)indices);
                TensorUtils.assertIndicesConsistency(t.get(i), temp);
                TensorUtils.appendAllIndicesT(t.get(i), sumIndices);
            }
            indices.addAll((TIntCollection)sumIndices);
        }
        if (t instanceof Expression) {
            for (Tensor c : t) {
                TensorUtils.assertIndicesConsistency(c, new TIntHashSet((TIntCollection)indices));
            }
        }
    }

    private static void appendAllIndicesT(Tensor tensor, TIntHashSet set) {
        if (tensor instanceof SimpleTensor) {
            Indices ind = tensor.getIndices();
            int size = ind.size();
            for (int i = 0; i < size; ++i) {
                set.add(ind.get(i));
            }
        } else if (tensor instanceof Power) {
            TensorUtils.appendAllIndicesT(tensor.get(0), set);
        } else {
            for (int i = tensor.size() - 1; i >= 0; --i) {
                Tensor t = tensor.get(i);
                if (t instanceof ScalarFunction) continue;
                TensorUtils.appendAllIndicesT(t, set);
            }
        }
    }

    public static boolean isZeroDueToSymmetry(Tensor t) {
        return IndexMappings.isZeroDueToSymmetry(t);
    }

    private static Permutation getSymmetryFromMapping1(int[] sortedIndicesNames, int[] _sortPermutation, Mapping mapping) {
        int i;
        int dimension = sortedIndicesNames.length;
        IntArray _fromIndices = mapping.getFromNames();
        IntArray _toIndices = mapping.getToData();
        int[] permutation = new int[dimension];
        Arrays.fill(permutation, -1);
        for (i = 0; i < dimension; ++i) {
            int fromIndex = sortedIndicesNames[i];
            int positionInFrom = ArraysUtils.binarySearch(_fromIndices, fromIndex);
            if (positionInFrom < 0) continue;
            int positionInIndices = Arrays.binarySearch(sortedIndicesNames, IndicesUtils.getNameWithType(_toIndices.get(positionInFrom)));
            if (positionInIndices < 0) {
                return Permutations.createIdentityPermutation(dimension);
            }
            permutation[_sortPermutation[i]] = _sortPermutation[positionInIndices];
        }
        for (i = 0; i < dimension; ++i) {
            if (permutation[i] != -1) continue;
            permutation[i] = i;
        }
        return Permutations.createPermutation(mapping.getSign(), permutation);
    }

    public static Permutation getSymmetryFromMapping(int[] indices, Mapping mapping) {
        int[] sortedIndicesNames = IndicesUtils.getIndicesNames(indices);
        int[] _sortPermutation = ArraysUtils.quickSortP(sortedIndicesNames);
        return TensorUtils.getSymmetryFromMapping1(sortedIndicesNames, _sortPermutation, mapping);
    }

    public static List<Permutation> getSymmetriesFromMappings(int[] indices, MappingsPort mappingsPort) {
        Mapping buffer;
        ArrayList<Permutation> symmetries = new ArrayList<Permutation>();
        int[] sortedIndicesNames = IndicesUtils.getIndicesNames(indices);
        int[] sortPermutation = ArraysUtils.quickSortP(sortedIndicesNames);
        while ((buffer = mappingsPort.take()) != null) {
            symmetries.add(TensorUtils.getSymmetryFromMapping1(sortedIndicesNames, sortPermutation, buffer));
        }
        return symmetries;
    }

    public static List<Permutation> findIndicesSymmetries(int[] indices, Tensor tensor) {
        return TensorUtils.getSymmetriesFromMappings(indices, IndexMappings.createPort(tensor, tensor));
    }

    public static List<Permutation> findIndicesSymmetries(SimpleIndices indices, Tensor tensor) {
        return TensorUtils.getSymmetriesFromMappings(indices.getAllIndices().copy(), IndexMappings.createPort(tensor, tensor));
    }

    public static List<Permutation> getIndicesSymmetriesForIndicesWithSameStates(int[] indices, Tensor tensor) {
        List<Permutation> total = TensorUtils.findIndicesSymmetries(indices, tensor);
        ArrayList<Permutation> symmetries = new ArrayList<Permutation>();
        block0: for (Permutation s : total) {
            for (int i = 0; i < indices.length; ++i) {
                if (IndicesUtils.getRawStateInt(indices[i]) != IndicesUtils.getRawStateInt(indices[s.newIndexOf(i)])) continue block0;
            }
            symmetries.add(s);
        }
        return symmetries;
    }

    public static Set<SimpleTensor> getAllSymbols(Tensor ... tensors) {
        HashSet<SimpleTensor> set = new HashSet<SimpleTensor>();
        for (Tensor tensor : tensors) {
            TensorUtils.addSymbols(tensor, set);
        }
        return set;
    }

    private static void addSymbols(Tensor tensor, Set<SimpleTensor> set) {
        if (TensorUtils.isSymbol(tensor)) {
            set.add((SimpleTensor)tensor);
        } else {
            for (Tensor t : tensor) {
                TensorUtils.addSymbols(t, set);
            }
        }
    }

    public static Set<SimpleTensor> getAllSymbolsAndSymbolicFields(Tensor ... tensors) {
        THashSet<SimpleTensor> set = new THashSet<SimpleTensor>();
        for (Tensor tensor : tensors) {
            TensorUtils.addSymbols(tensor, set);
        }
        return set;
    }

    private static void addSymbolsAndSymbolicFields(Tensor tensor, Set<SimpleTensor> set) {
        if (tensor instanceof SimpleTensor && tensor.getIndices().size() == 0) {
            boolean contentSymbolicQ = true;
            for (Tensor t : tensor) {
                if (TensorUtils.isSymbolic(t)) continue;
                contentSymbolicQ = false;
                break;
            }
            if (contentSymbolicQ) {
                set.add((SimpleTensor)tensor);
            }
        } else {
            for (Tensor t : tensor) {
                TensorUtils.addSymbolsAndSymbolicFields(t, set);
            }
        }
    }

    public static Collection<SimpleTensor> getAllDiffSimpleTensors(Tensor ... tensors) {
        TIntObjectHashMap names = new TIntObjectHashMap();
        for (Tensor tensor : tensors) {
            TensorUtils.addAllDiffSimpleTensors(tensor, (TIntObjectHashMap<SimpleTensor>)names);
        }
        return names.valueCollection();
    }

    private static void addAllDiffSimpleTensors(Tensor tensor, TIntObjectHashMap<SimpleTensor> names) {
        if (tensor instanceof SimpleTensor) {
            names.put(((SimpleTensor)tensor).getName(), (Object)((SimpleTensor)tensor));
        } else {
            for (Tensor t : tensor) {
                TensorUtils.addAllDiffSimpleTensors(t, names);
            }
        }
    }

    public static TIntHashSet getAllNamesOfSymbols(Tensor ... tensors) {
        TIntHashSet set = new TIntHashSet();
        for (Tensor tensor : tensors) {
            TensorUtils.addSymbolsNames(tensor, set);
        }
        return set;
    }

    private static void addSymbolsNames(Tensor tensor, TIntHashSet set) {
        if (TensorUtils.isSymbol(tensor)) {
            set.add(((SimpleTensor)tensor).getName());
        } else {
            for (Tensor t : tensor) {
                TensorUtils.addSymbolsNames(t, set);
            }
        }
    }

    public static int treeDepth(Tensor tensor) {
        if (tensor.getClass() == SimpleTensor.class || tensor instanceof Complex) {
            return 0;
        }
        int depth = 1;
        for (Tensor t : tensor) {
            int temp = TensorUtils.treeDepth(t) + 1;
            if (temp <= depth) continue;
            depth = temp;
        }
        return depth;
    }

    public static Tensor det(Tensor[][] matrix) {
        TensorUtils.checkMatrix(matrix);
        return TensorUtils.det1(matrix);
    }

    private static void checkMatrix(Tensor[][] tensors) {
        int cc = tensors.length;
        for (Tensor[] tt : tensors) {
            if (tt.length == cc) continue;
            throw new IllegalArgumentException("Non square matrix");
        }
    }

    private static Tensor det1(Tensor[][] matrix) {
        if (matrix.length == 1) {
            return matrix[0][0];
        }
        SumBuilder sum = new SumBuilder();
        for (int i = 0; i < matrix.length; ++i) {
            Tensor temp = Tensors.multiply(matrix[0][i], TensorUtils.det(TensorUtils.deleteFromMatrix(matrix, 0, i)));
            if (i % 2 == 1) {
                temp = Tensors.negate(temp);
            }
            sum.put(temp);
        }
        return sum.build();
    }

    private static Tensor[][] deleteFromMatrix(Tensor[][] matrix, int row, int column) {
        if (matrix.length == 1) {
            return new Tensor[0][0];
        }
        Tensor[][] newMatrix = new Tensor[matrix.length - 1][matrix.length - 1];
        int cRow = 0;
        for (int i = 0; i < matrix.length; ++i) {
            if (i == row) continue;
            int cColumn = 0;
            for (int j = 0; j < matrix.length; ++j) {
                if (j == column) continue;
                newMatrix[cRow][cColumn++] = matrix[i][j];
            }
            ++cRow;
        }
        return newMatrix;
    }

    public static boolean containsFractions(Tensor tensor) {
        if (tensor instanceof SimpleTensor) {
            return false;
        }
        if (tensor instanceof Power) {
            return TensorUtils.isNegativeNaturalNumber(tensor.get(1));
        }
        for (Tensor t : tensor) {
            if (!TensorUtils.containsFractions(t)) continue;
            return true;
        }
        return false;
    }

    public static TIntHashSet getSimpleTensorsNames(Tensor t) {
        return TensorUtils.addSimpleTensorsNames(t, new TIntHashSet());
    }

    private static TIntHashSet addSimpleTensorsNames(Tensor t, TIntHashSet names) {
        if (t instanceof TensorField) {
            names.add(((TensorField)t).getNameDescriptor().getParent().getId());
        }
        if (t instanceof SimpleTensor) {
            names.add(((SimpleTensor)t).getName());
        }
        for (Tensor tt : t) {
            TensorUtils.addSimpleTensorsNames(tt, names);
        }
        return names;
    }

    public static boolean shareSimpleTensors(Tensor a, Tensor b) {
        return TensorUtils.testContainsNames(b, TensorUtils.getSimpleTensorsNames(a));
    }

    private static boolean testContainsNames(Tensor t, TIntHashSet names) {
        if (t instanceof TensorField) {
            if (names.contains(((TensorField)t).getNameDescriptor().getParent().getId())) {
                return true;
            }
        } else if (t instanceof SimpleTensor) {
            return names.contains(((SimpleTensor)t).getName());
        }
        for (Tensor tt : t) {
            if (!TensorUtils.testContainsNames(tt, names)) continue;
            return true;
        }
        return false;
    }

    public static Expression[] generateReplacementsOfScalars(Tensor tensor) {
        return TensorUtils.generateReplacementsOfScalars(tensor, CC.getParametersGenerator());
    }

    public static Expression[] generateReplacementsOfScalars(Tensor tensor, OutputPort<SimpleTensor> generatedCoefficients) {
        Tensor c;
        THashSet<Tensor> scalars = new THashSet<Tensor>();
        FromChildToParentIterator iterator = new FromChildToParentIterator(tensor);
        while ((c = iterator.next()) != null) {
            if (!(c instanceof Product)) continue;
            scalars.addAll((Collection<Tensor>)Arrays.asList(((Product)c).getContent().getScalars()));
        }
        Expression[] replacements = new Expression[scalars.size()];
        int i = -1;
        for (Tensor scalar : scalars) {
            replacements[++i] = Tensors.expression(scalar, generatedCoefficients.take());
        }
        return replacements;
    }
}

