/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.TensorWrapperWithEquals;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class THashSet<T extends Tensor>
implements Set<T> {
    private final HashSet<TensorWrapperWithEquals> set;

    public THashSet() {
        this.set = new HashSet();
    }

    public THashSet(int initialCapacity) {
        this.set = new HashSet(initialCapacity);
    }

    public THashSet(int initialCapacity, float loadFactor) {
        this.set = new HashSet(initialCapacity, loadFactor);
    }

    public THashSet(Collection<? extends Tensor> tensors) {
        ArrayList<TensorWrapperWithEquals> wrappers = new ArrayList<TensorWrapperWithEquals>(tensors.size());
        for (Tensor tensor : tensors) {
            wrappers.add(new TensorWrapperWithEquals(tensor));
        }
        this.set = new HashSet(wrappers);
    }

    @Override
    public boolean add(T e) {
        return this.set.add(new TensorWrapperWithEquals((Tensor)e));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        ArrayList<TensorWrapperWithEquals> wrappers = new ArrayList<TensorWrapperWithEquals>(c.size());
        for (Tensor t : c) {
            wrappers.add(new TensorWrapperWithEquals(t));
        }
        return this.set.addAll(wrappers);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Tensor) {
            return this.set.contains(new TensorWrapperWithEquals((Tensor)o));
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new SetIterator(this.set.iterator());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Tensor) {
            return this.set.remove(new TensorWrapperWithEquals((Tensor)o));
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            b = true;
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = -1;
        for (TensorWrapperWithEquals tw : this.set) {
            a[++i] = tw.tensor;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] r = a.length >= this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int i = -1;
        for (TensorWrapperWithEquals tw : this.set) {
            r[++i] = tw.tensor;
        }
        return r;
    }

    private final class SetIterator<T>
    implements Iterator<T> {
        private final Iterator<TensorWrapperWithEquals> iterator;

        public SetIterator(Iterator<TensorWrapperWithEquals> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return (T)this.iterator.next().tensor;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

